/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class TicketState {
    @Nonnull
    private String sessId;
    @Nonnull
    private String authenticatedPrincipalName;
    @Nonnull
    private Instant authenticationInstant;
    @Nonnull
    private String authenticationMethod;

    public TicketState(@Nonnull String sessionId, @Nonnull String principalName, @Nonnull Instant authnInstant, @Nonnull String authnMethod) {
        this.sessId = (String)Constraint.isNotNull((Object)sessionId, (String)"SessionID cannot be null");
        this.authenticatedPrincipalName = (String)Constraint.isNotNull((Object)principalName, (String)"PrincipalName cannot be null");
        this.authenticationInstant = (Instant)Constraint.isNotNull((Object)authnInstant, (String)"AuthnInstant cannot be null");
        this.authenticationMethod = (String)Constraint.isNotNull((Object)authnMethod, (String)"AuthnMethod cannot be null");
    }

    @Nonnull
    public String getSessionId() {
        return this.sessId;
    }

    @Nonnull
    public String getPrincipalName() {
        return this.authenticatedPrincipalName;
    }

    @Nonnull
    public Instant getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    @Nonnull
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public boolean equals(Object o) {
        if (o instanceof TicketState) {
            TicketState other = (TicketState)o;
            return this.sessId.equals(other.sessId) && this.authenticatedPrincipalName.equals(other.authenticatedPrincipalName) && this.authenticationInstant.equals(other.authenticationInstant) && this.authenticationMethod.equals(other.authenticationMethod);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sessId, this.authenticatedPrincipalName, this.authenticationInstant, this.authenticationMethod);
    }
}

