/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import net.shibboleth.idp.cas.service.DefaultServiceComparator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultServiceComparatorTest {
    @Test
    public void testCompareSame() throws Exception {
        Assert.assertEquals((int)new DefaultServiceComparator().compare("https://a.example.com/foo?bar=baz", "https://A.example.com/Foo?bar=BAZ"), (int)0);
    }

    @Test
    public void testCompareDifferent() throws Exception {
        Assert.assertEquals((int)new DefaultServiceComparator().compare("https://a.example.com/foo?bar=1", "https://a.example.com/Foo?bar=2"), (int)-1);
    }

    @Test
    public void testCompareSameWithJSessionID() throws Exception {
        Assert.assertEquals((int)new DefaultServiceComparator().compare("https://a.example.com/foo/bar?baz=1", "https://A.example.com/Foo;jsessionid=abacefghijklmnop/bar?BAZ=1"), (int)0);
    }

    @Test
    public void testCompareDifferentWithJSessionID() throws Exception {
        Assert.assertFalse((new DefaultServiceComparator().compare("https://a.example.com/foo/bar?baz=1", "https://A.example.com/Foo;jsessionid=abacefghijklmnop;a=b/bar?BAZ=1") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareSameWithMultipleParams() throws Exception {
        Assert.assertEquals((int)new DefaultServiceComparator(new String[]{"a", "b", "c"}).compare("https://a.sub.example.com/foo/bar?baz=1", "https://a.sub.example.com/Foo;a=1;b=2/bar;c=3?BAZ=1"), (int)0);
    }
}

