/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.service.PatternServiceRegistry;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceDefinition;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PatternServiceRegistryTest {
    @DataProvider(name="services")
    public Object[][] getServices() {
        ServiceDefinition d1 = new ServiceDefinition("https://([A-Za-z0-9_-]+\\.)*example\\.org(:\\d+)?/.*");
        d1.setGroup("example.org-plus-subdomains");
        d1.setAuthorizedToProxy(false);
        ServiceDefinition d2 = new ServiceDefinition("https://trusted\\.example\\.org/.*");
        d2.setGroup("trusted-service");
        d2.setAuthorizedToProxy(true);
        return new Object[][]{{Arrays.asList(d1, d2), "https://trusted.example.org/landing", new Service("https://trusted.example.org/landing", "example.org-plus-subdomains", false)}, {Arrays.asList(d2, d1), "https://trusted.example.org/landing", new Service("https://trusted.example.org/landing", "trusted-service", true)}, {Arrays.asList(d1, d2), "https://service.untrusted.org/landing", null}};
    }

    @Test(dataProvider="services")
    public void testLookup(@Nonnull List<ServiceDefinition> services, @Nonnull String serviceURL, Service expected) throws Exception {
        PatternServiceRegistry registry = new PatternServiceRegistry();
        registry.setDefinitions(services);
        Service actual = registry.lookup(serviceURL);
        if (expected == null) {
            assert (actual == null);
        } else {
            assert (actual != null);
            Assert.assertEquals((String)actual.getName(), (String)expected.getName());
            Assert.assertEquals((String)actual.getGroup(), (String)expected.getGroup());
            Assert.assertEquals((boolean)actual.isAuthorizedToProxy(), (boolean)expected.isAuthorizedToProxy());
        }
    }
}

