/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TicketIdentifierGenerationStrategyTest {
    private static final Pattern TICKET_REGEX = Pattern.compile("(.+)-(\\d+)-([A-Za-z0-9]+)(-(.+))?");

    @DataProvider(name="generators")
    public Object[][] provideGenerators() {
        TicketIdentifierGenerationStrategy gen1 = new TicketIdentifierGenerationStrategy("ST", 25);
        gen1.setSuffix("node_1-1");
        TicketIdentifierGenerationStrategy gen2 = new TicketIdentifierGenerationStrategy("PT", 25);
        gen2.setSuffix("host1.example.com");
        TicketIdentifierGenerationStrategy gen3 = new TicketIdentifierGenerationStrategy("PGT", 50);
        return new Object[][]{{gen1, "ST", 25, "node_1-1"}, {gen2, "PT", 25, "host1.example.com"}, {gen3, "PGT", 50, null}};
    }

    @DataProvider(name="url-safety")
    public Object[][] provideBadPrefixSuffix() {
        return new Object[][]{{"<ST>", "host"}, {"PGT", "http://host.example.com/"}};
    }

    @Test(dataProvider="generators")
    public void testGenerate(TicketIdentifierGenerationStrategy generator, String expectedPrefix, int expectedRandomLength, String expectedSuffix) throws Exception {
        long now = System.currentTimeMillis();
        String id = generator.generateIdentifier();
        Matcher m = TICKET_REGEX.matcher(id);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertEquals((String)m.group(1), (String)expectedPrefix);
        Assert.assertEquals((long)(Long.parseLong(m.group(2)) / now), (long)1L);
        Assert.assertEquals((int)m.group(3).length(), (int)expectedRandomLength);
        if (expectedSuffix != null) {
            Assert.assertEquals((String)m.group(5), (String)expectedSuffix);
        }
    }

    @Test(dataProvider="url-safety", expectedExceptions={ConstraintViolationException.class})
    public void testUrlSafety(@Nonnull String prefix, String suffix) {
        new TicketIdentifierGenerationStrategy(prefix, 10).setSuffix(suffix);
    }

    @Test
    public void testConcurrentGeneration() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(20);
        final TicketIdentifierGenerationStrategy generator = new TicketIdentifierGenerationStrategy("ST", 50);
        ArrayList<1> tasks = new ArrayList<1>();
        for (int i = 0; i < 20; ++i) {
            tasks.add(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return generator.generateIdentifier();
                }
            });
        }
        List results = executor.invokeAll(tasks);
        for (Future result : results) {
            Assert.assertNotNull(result.get(1L, TimeUnit.SECONDS));
        }
    }
}

