/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import java.time.Duration;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.config.AbstractProtocolConfiguration;
import net.shibboleth.idp.cas.service.DefaultServiceComparator;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;

public class ValidateConfiguration
extends AbstractProtocolConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "https://www.apereo.org/cas/protocol/serviceValidate";
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.cas.serviceValidate";
    @Nonnull
    public static final Duration DEFAULT_TICKET_VALIDITY_PERIOD = Duration.ofHours(12L);
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TICKET_PREFIX = "PGT";
    public static final int DEFAULT_TICKET_LENGTH = 50;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> pgtIOUGeneratorLookupStrategy;
    @Nonnull
    private final IdentifierGenerationStrategy defaultPGTIOUGenerator;
    @Nonnull
    private Function<ProfileRequestContext, Comparator<String>> serviceComparatorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> userAttributeLookupStrategy;

    public ValidateConfiguration() {
        super(PROFILE_ID);
        this.setTicketValidityPeriod(DEFAULT_TICKET_VALIDITY_PERIOD);
        this.userAttributeLookupStrategy = FunctionSupport.constant(null);
        this.serviceComparatorLookupStrategy = FunctionSupport.constant((Object)new DefaultServiceComparator());
        this.defaultPGTIOUGenerator = new TicketIdentifierGenerationStrategy("PGTIOU", 50);
        this.pgtIOUGeneratorLookupStrategy = FunctionSupport.constant((Object)this.defaultPGTIOUGenerator);
    }

    @ConfigurationSetting(name="pGTIOUGenerator")
    @Nonnull
    public IdentifierGenerationStrategy getPGTIOUGenerator(@Nullable ProfileRequestContext profileRequestContext) {
        IdentifierGenerationStrategy strategy = this.pgtIOUGeneratorLookupStrategy.apply(profileRequestContext);
        return strategy != null ? strategy : this.defaultPGTIOUGenerator;
    }

    public void setPGTIOUGenerator(@Nonnull IdentifierGenerationStrategy generator) {
        this.pgtIOUGeneratorLookupStrategy = FunctionSupport.constant((Object)((IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"Generator cannot be null")));
    }

    public void setPGTIOUGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.pgtIOUGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @ConfigurationSetting(name="serviceComparator")
    @Nonnull
    public Comparator<String> getServiceComparator(@Nullable ProfileRequestContext profileRequestContext) {
        return (Comparator)Constraint.isNotNull(this.serviceComparatorLookupStrategy.apply(profileRequestContext), (String)"Service comparator cannot be null");
    }

    public void setServiceComparator(@Nonnull Comparator<String> comparator) {
        this.serviceComparatorLookupStrategy = FunctionSupport.constant((Object)((Comparator)Constraint.isNotNull(comparator, (String)"ServiceComparator cannot be null")));
    }

    public void setServiceComparatorLookupStrategy(@Nonnull Function<ProfileRequestContext, Comparator<String>> strategy) {
        this.serviceComparatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @ConfigurationSetting(name="userAttribute")
    @Nullable
    public String getUserAttribute(@Nullable ProfileRequestContext profileRequestContext) {
        return this.userAttributeLookupStrategy.apply(profileRequestContext);
    }

    public void setUserAttribute(@Nullable String attribute) {
        this.userAttributeLookupStrategy = FunctionSupport.constant((Object)attribute);
    }

    public void setUserAttributeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.userAttributeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getDefaultTicketPrefix() {
        return DEFAULT_TICKET_PREFIX;
    }

    @Override
    protected int getDefaultTicketLength() {
        return 50;
    }
}

