/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class TicketState {
    @Nullable
    private String sessId;
    @Nonnull
    private String authenticatedPrincipalName;
    @Nonnull
    private Instant authenticationInstant;
    @Nonnull
    private String authenticationMethod;
    @Nullable
    private Set<String> consentedAttributeIds;

    public TicketState(@Nullable String sessionId, @Nonnull String principalName, @Nonnull Instant authnInstant, @Nonnull String authnMethod) {
        this.sessId = sessionId;
        this.authenticatedPrincipalName = (String)Constraint.isNotNull((Object)principalName, (String)"PrincipalName cannot be null");
        this.authenticationInstant = (Instant)Constraint.isNotNull((Object)authnInstant, (String)"AuthnInstant cannot be null");
        this.authenticationMethod = (String)Constraint.isNotNull((Object)authnMethod, (String)"AuthnMethod cannot be null");
    }

    @Nullable
    public String getSessionId() {
        return this.sessId;
    }

    @Nonnull
    public String getPrincipalName() {
        return this.authenticatedPrincipalName;
    }

    @Nonnull
    public Instant getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    @Nonnull
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public Set<String> getConsentedAttributeIds() {
        return this.consentedAttributeIds;
    }

    public void setConsentedAttributeIds(@Nullable Collection<String> attributeIds) {
        this.consentedAttributeIds = attributeIds != null ? CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(attributeIds)) : null;
    }

    public boolean equals(Object o) {
        if (o instanceof TicketState) {
            TicketState other = (TicketState)o;
            return Objects.equals(this.sessId, other.sessId) && this.authenticatedPrincipalName.equals(other.authenticatedPrincipalName) && this.authenticationInstant.equals(other.authenticationInstant) && this.authenticationMethod.equals(other.authenticationMethod);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sessId, this.authenticatedPrincipalName, this.authenticationInstant, this.authenticationMethod);
    }
}

