/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.profile.config.AbstractProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;

public abstract class AbstractProtocolConfiguration
extends AbstractProfileConfiguration
implements InitializableComponent {
    public static final String PROTOCOL_URI = "https://www.apereo.org/cas/protocol";
    private boolean initialized;
    @Duration
    @Positive
    private long ticketValidityPeriod;

    public AbstractProtocolConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSecurityConfiguration(new SecurityConfiguration(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES), (IdentifierGenerationStrategy)new TicketIdentifierGenerationStrategy(this.getDefaultTicketPrefix(), this.getDefaultTicketLength())));
    }

    public void initialize() throws ComponentInitializationException {
        Constraint.isNotNull((Object)this.getSecurityConfiguration(), (String)"Security configuration cannot be null.");
        Constraint.isNotNull((Object)this.getSecurityConfiguration().getIdGenerator(), (String)"Security configuration ID generator cannot be null.");
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Positive
    public long getTicketValidityPeriod() {
        return this.ticketValidityPeriod;
    }

    public void setTicketValidityPeriod(@Duration @Positive long millis) {
        this.ticketValidityPeriod = Constraint.isGreaterThan((long)0L, (long)millis, (String)"Ticket validity period must be positive.");
    }

    @Nonnull
    protected abstract String getDefaultTicketPrefix();

    @Nonnull
    protected abstract int getDefaultTicketLength();
}

