/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.Events;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CheckAuthenticationRequiredAction
extends AbstractCASProtocolAction<ServiceTicketRequest, ServiceTicketResponse> {
    private final Logger log = LoggerFactory.getLogger(CheckAuthenticationRequiredAction.class);

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ServiceTicketRequest request = (ServiceTicketRequest)this.getCASRequest(profileRequestContext);
        if (request.isRenew()) {
            return new Event((Object)this, Events.RenewRequested.id());
        }
        if (request.isGateway()) {
            return new Event((Object)this, Events.GatewayRequested.id());
        }
        try {
            IdPSession session = this.getIdPSession(profileRequestContext);
            this.log.debug("Found session ID {}", (Object)session.getId());
            try {
                if (session.checkTimeout()) {
                    return Events.SessionFound.event((Object)this);
                }
            }
            catch (SessionException e) {
                this.log.debug("Error performing session timeout check. Assuming session has expired.", (Throwable)e);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug("IdP session not found");
        }
        return Events.SessionNotFound.event((Object)this);
    }
}

