/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.ProxyConfiguration;
import net.shibboleth.idp.cas.flow.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.Events;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GrantProxyTicketAction
extends AbstractCASProtocolAction<ProxyTicketRequest, ProxyTicketResponse> {
    private final Logger log = LoggerFactory.getLogger(GrantProxyTicketAction.class);
    private final ConfigLookupFunction<ProxyConfiguration> configLookupFunction = new ConfigLookupFunction<ProxyConfiguration>(ProxyConfiguration.class);
    @Nonnull
    private final TicketService ticketService;

    public GrantProxyTicketAction(TicketService ticketService) {
        this.ticketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ProxyTicket pt;
        ProxyTicketRequest request = (ProxyTicketRequest)this.getCASRequest(profileRequestContext);
        ProxyGrantingTicket pgt = (ProxyGrantingTicket)this.getCASTicket(profileRequestContext);
        ProxyConfiguration config = this.configLookupFunction.apply(profileRequestContext);
        if (config == null) {
            this.log.info("Proxy ticket configuration undefined");
            return ProtocolError.IllegalState.event((Object)this);
        }
        if (config.getSecurityConfiguration() == null || config.getSecurityConfiguration().getIdGenerator() == null) {
            this.log.info("Invalid proxy ticket configuration: SecurityConfiguration#idGenerator undefined");
            return ProtocolError.IllegalState.event((Object)this);
        }
        try {
            this.log.debug("Granting proxy ticket for {}", (Object)request.getTargetService());
            pt = this.ticketService.createProxyTicket(config.getSecurityConfiguration().getIdGenerator().generateIdentifier(), DateTime.now().plus(config.getTicketValidityPeriod()).toInstant(), pgt, request.getTargetService());
        }
        catch (RuntimeException e) {
            this.log.error("Failed granting proxy ticket due to error.", (Throwable)e);
            return ProtocolError.TicketCreationError.event((Object)this);
        }
        this.log.info("Granted proxy ticket for {}", (Object)request.getTargetService());
        this.setCASResponse(profileRequestContext, new ProxyTicketResponse(pt.getId()));
        return Events.Success.event((Object)this);
    }
}

