/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.LoginConfiguration;
import net.shibboleth.idp.cas.flow.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.Events;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GrantServiceTicketAction
extends AbstractCASProtocolAction<ServiceTicketRequest, ServiceTicketResponse> {
    private final Logger log = LoggerFactory.getLogger(GrantServiceTicketAction.class);
    private final ConfigLookupFunction<LoginConfiguration> configLookupFunction = new ConfigLookupFunction<LoginConfiguration>(LoginConfiguration.class);
    @Nonnull
    private final TicketService ticketService;

    public GrantServiceTicketAction(@Nonnull TicketService ticketService) {
        this.ticketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ServiceTicket ticket;
        ServiceTicketRequest request = (ServiceTicketRequest)this.getCASRequest(profileRequestContext);
        IdPSession session = this.getIdPSession(profileRequestContext);
        LoginConfiguration config = this.configLookupFunction.apply(profileRequestContext);
        if (config == null) {
            this.log.info("Service ticket configuration undefined");
            return ProtocolError.IllegalState.event((Object)this);
        }
        if (config.getSecurityConfiguration() == null || config.getSecurityConfiguration().getIdGenerator() == null) {
            this.log.info("Invalid service ticket configuration: SecurityConfiguration#idGenerator undefined");
            return ProtocolError.IllegalState.event((Object)this);
        }
        try {
            this.log.debug("Granting service ticket for {}", (Object)request.getService());
            ticket = this.ticketService.createServiceTicket(config.getSecurityConfiguration().getIdGenerator().generateIdentifier(), DateTime.now().plus(config.getTicketValidityPeriod()).toInstant(), session.getId(), request.getService(), request.isRenew());
        }
        catch (RuntimeException e) {
            this.log.error("Failed granting service ticket due to error.", (Throwable)e);
            return ProtocolError.TicketCreationError.event((Object)this);
        }
        this.log.info("Granted service ticket for {}", (Object)request.getService());
        ServiceTicketResponse response = new ServiceTicketResponse(request.getService(), ticket.getId());
        if (request.isSAML()) {
            response.setSaml(true);
        }
        this.setCASResponse(profileRequestContext, response);
        return Events.Success.event((Object)this);
    }
}

