/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.Events;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidateRenewAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private final Logger log = LoggerFactory.getLogger(ValidateRenewAction.class);

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        TicketValidationRequest request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
        Ticket ticket = this.getCASTicket(profileRequestContext);
        if (ticket instanceof ServiceTicket) {
            if (request.isRenew() != ((ServiceTicket)ticket).isRenew()) {
                this.log.debug("Renew=true requested at validation time but ticket not issued with renew=true.");
                return ProtocolError.TicketNotFromRenew.event((Object)this);
            }
        } else if (request.isRenew()) {
            return ProtocolError.RenewIncompatibleWithProxy.event((Object)this);
        }
        return Events.Success.event((Object)this);
    }
}

