/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.proxy;

import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.login.FailedLoginException;
import net.shibboleth.idp.cas.proxy.ProxyAuthenticator;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;

public abstract class AbstractProxyAuthenticator
implements ProxyAuthenticator<TrustEngine<? super X509Credential>> {
    protected static final String HTTPS_SCHEME = "https";
    @NotEmpty
    @NonnullElements
    private Set<Integer> allowedResponseCodes = Collections.singleton(200);

    public void setAllowedResponseCodes(@NotEmpty @NonnullElements Set<Integer> responseCodes) {
        Constraint.isNotEmpty(responseCodes, (String)"Response codes cannot be null or empty.");
        Constraint.noNullItems((Object[])responseCodes.toArray(), (String)"Response codes cannot contain null elements.");
        this.allowedResponseCodes = responseCodes;
    }

    public final void authenticate(@Nonnull URI credential, @Nullable TrustEngine<? super X509Credential> criteria) throws GeneralSecurityException {
        Constraint.isNotNull((Object)credential, (String)"URI to authenticate cannot be null.");
        if (!HTTPS_SCHEME.equalsIgnoreCase(credential.getScheme())) {
            throw new GeneralSecurityException(credential + " is not an https URI as required.");
        }
        int status = this.authenticateProxyCallback(credential, criteria);
        if (!this.allowedResponseCodes.contains(status)) {
            throw new FailedLoginException(credential + " returned unacceptable HTTP status code " + status);
        }
    }

    protected abstract int authenticateProxyCallback(@Nonnull URI var1, @Nullable TrustEngine<? super X509Credential> var2) throws GeneralSecurityException;
}

