/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceComparator
implements Comparator<String> {
    private final Logger log = LoggerFactory.getLogger(DefaultServiceComparator.class);
    private final Pattern[] ignoredPatterns;

    public DefaultServiceComparator() {
        this("jsessionid");
    }

    public DefaultServiceComparator(String ... parameterNames) {
        Constraint.isNotNull((Object)parameterNames, (String)"Parameters names cannot be null");
        this.ignoredPatterns = new Pattern[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            this.ignoredPatterns[i] = Pattern.compile(";" + parameterNames[i] + "(?:=[^;/]+)?", 2);
        }
    }

    @Override
    public int compare(String a, String b) {
        return this.stripPathParameters(a).compareToIgnoreCase(this.stripPathParameters(b));
    }

    private String stripPathParameters(String uriString) {
        try {
            URI uri = new URI(uriString);
            String path = uri.getPath();
            for (Pattern pattern : this.ignoredPatterns) {
                Matcher m = pattern.matcher(path);
                path = m.replaceAll("");
            }
            return new URI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            this.log.warn("Error parsing {}", (Object)uriString);
            return uriString;
        }
    }
}

