/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class ServiceDefinition {
    @Nonnull
    private final Pattern matchPattern;
    @Nullable
    private String group;
    private boolean authorizedToProxy;

    public ServiceDefinition(@Nonnull @NotEmpty String regex) {
        this.matchPattern = Pattern.compile((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)regex), (String)"Regular expression cannot be null or empty"));
    }

    public ServiceDefinition(@Nonnull Pattern pattern) {
        this.matchPattern = (Pattern)Constraint.isNotNull((Object)pattern, (String)"Pattern cannot be null or empty");
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotEmpty String group) {
        this.group = StringSupport.trimOrNull((String)group);
    }

    public boolean isAuthorizedToProxy() {
        return this.authorizedToProxy;
    }

    public void setAuthorizedToProxy(boolean proxy) {
        this.authorizedToProxy = proxy;
    }

    public boolean matches(String serviceURL) {
        return this.matchPattern.matcher(serviceURL).matches();
    }

    public String toString() {
        return this.matchPattern.pattern();
    }
}

