/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class BuildRelyingPartyContextAction
extends AbstractCASProtocolAction {
    public static final String UNVERIFIED_GROUP = "unverified";
    private final Logger log = LoggerFactory.getLogger(BuildRelyingPartyContextAction.class);
    @Nonnull
    @NotEmpty
    private final List<ServiceRegistry> serviceRegistries;

    public BuildRelyingPartyContextAction(ServiceRegistry ... registries) {
        this.serviceRegistries = Arrays.asList(Constraint.isNotEmpty((Object[])registries, (String)"Service registries cannot be null"));
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        String serviceURL;
        Object request = this.getCASRequest(profileRequestContext);
        if (request instanceof ServiceTicketRequest) {
            serviceURL = ((ServiceTicketRequest)request).getService();
        } else if (request instanceof ProxyTicketRequest) {
            serviceURL = ((ProxyTicketRequest)request).getTargetService();
        } else if (request instanceof TicketValidationRequest) {
            serviceURL = ((TicketValidationRequest)request).getService();
        } else {
            throw new IllegalStateException("Service URL not found in flow state");
        }
        Service service = this.query(serviceURL);
        RelyingPartyContext rpc = new RelyingPartyContext();
        rpc.setVerified(Boolean.valueOf(service != null));
        rpc.setRelyingPartyId(serviceURL);
        if (service != null) {
            this.log.debug("Setting up RP context for verified relying party {}", (Object)service);
        } else {
            service = new Service(serviceURL, UNVERIFIED_GROUP, false);
            this.log.debug("Setting up RP context for unverified relying party {}", (Object)service);
        }
        this.log.debug("Relying party context created for {}", (Object)service);
        profileRequestContext.addSubcontext((BaseContext)rpc);
        this.setCASService(profileRequestContext, service);
        return null;
    }

    private Service query(String serviceURL) {
        for (ServiceRegistry registry : this.serviceRegistries) {
            this.log.debug("Querying {} for CAS service URL {}", (Object)registry.getClass().getName(), (Object)serviceURL);
            Service service = registry.lookup(serviceURL);
            if (service == null) continue;
            return service;
        }
        return null;
    }
}

