/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.session.impl.CASSPSession;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class UpdateIdPSessionWithSPSessionAction
extends AbstractCASProtocolAction {
    private final Logger log = LoggerFactory.getLogger(UpdateIdPSessionWithSPSessionAction.class);
    @Nonnull
    private final SessionResolver sessionResolver;
    @Duration
    @Positive
    private final long sessionLifetime;

    public UpdateIdPSessionWithSPSessionAction(@Nonnull SessionResolver resolver, @Duration @Positive long lifetime) {
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"Session resolver cannot be null.");
        this.sessionLifetime = Constraint.isGreaterThan((long)0L, (long)lifetime, (String)"Lifetime must be greater than 0");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        Ticket ticket = this.getCASTicket(profileRequestContext);
        Service service = this.getCASService(profileRequestContext);
        if (!service.isSingleLogoutParticipant()) {
            return null;
        }
        IdPSession session = null;
        try {
            this.log.debug("Attempting to retrieve session {}", (Object)ticket.getSessionId());
            session = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(ticket.getSessionId())}));
        }
        catch (ResolverException e) {
            this.log.warn("Possible sign of misconfiguration, IdPSession resolution error: {}", (Throwable)e);
        }
        if (session != null) {
            long now = System.currentTimeMillis();
            CASSPSession sps = new CASSPSession(ticket.getService(), now, now + this.sessionLifetime, ticket.getId());
            this.log.debug("Created SP session {}", (Object)sps);
            try {
                session.addSPSession((SPSession)sps);
            }
            catch (SessionException e) {
                this.log.warn("Failed updating IdPSession with CASSPSession", (Throwable)e);
            }
        } else {
            this.log.info("Cannot store CASSPSession since IdPSession not found");
        }
        return null;
    }
}

