/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.proxy.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.security.auth.login.FailedLoginException;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.proxy.ProxyValidator;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProxyValidator
implements ProxyValidator {
    protected static final String HTTPS_SCHEME = "https";
    private static final int DEFAULT_TIMEOUT = 800;
    private final Logger log = LoggerFactory.getLogger(HttpClientProxyValidator.class);
    @Nonnull
    private final TrustEngine<? super X509Credential> trustEngine;
    private final Function<ProfileRequestContext, ServiceContext> serviceCtxLookupFunction = Functions.compose((Function)new ChildContextLookup(ServiceContext.class), (Function)new ChildContextLookup(ProtocolContext.class));
    @NotEmpty
    @NonnullElements
    private Set<Integer> allowedResponseCodes = Collections.singleton(200);
    @Positive
    private int timeout = 800;

    public HttpClientProxyValidator(@Nonnull TrustEngine<? super X509Credential> engine) {
        this.trustEngine = (TrustEngine)Constraint.isNotNull(engine, (String)"Trust engine cannot be null");
    }

    public void setTimeout(@Positive int timeoutMillis) {
        this.timeout = (int)Constraint.isGreaterThan((long)0L, (long)timeoutMillis, (String)"Timeout must be positive");
    }

    public void setAllowedResponseCodes(@NotEmpty @NonnullElements Set<Integer> responseCodes) {
        Constraint.isNotEmpty(responseCodes, (String)"Response codes cannot be null or empty.");
        Constraint.noNullItems((Object[])responseCodes.toArray(), (String)"Response codes cannot contain null elements.");
        this.allowedResponseCodes = responseCodes;
    }

    public void validate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull URI proxyCallbackUri) throws GeneralSecurityException {
        Constraint.isNotNull((Object)proxyCallbackUri, (String)"Proxy callback URI cannot be null");
        if (!HTTPS_SCHEME.equalsIgnoreCase(proxyCallbackUri.getScheme())) {
            throw new GeneralSecurityException(proxyCallbackUri + " is not an https URI as required.");
        }
        ServiceContext serviceContext = (ServiceContext)this.serviceCtxLookupFunction.apply((Object)profileRequestContext);
        if (serviceContext == null) {
            throw new IllegalStateException("Service context not found in profile request context as required");
        }
        int status = this.connect(proxyCallbackUri, serviceContext.getService());
        if (!this.allowedResponseCodes.contains(status)) {
            throw new FailedLoginException(proxyCallbackUri + " returned unacceptable HTTP status code: " + status);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int connect(@Nonnull URI uri, @Nonnull Service service) throws GeneralSecurityException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = this.createHttpClient(service);
            this.log.debug("Attempting to connect to {}", (Object)uri);
            HttpGet request = new HttpGet(uri);
            request.setConfig(RequestConfig.custom().setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).build());
            response = httpClient.execute((HttpUriRequest)request);
            int n = response.getStatusLine().getStatusCode();
            this.close((Closeable)response);
            this.close((Closeable)httpClient);
            return n;
        }
        catch (ClientProtocolException e) {
            try {
                throw new GeneralSecurityException("HTTP protocol error", e);
                catch (SSLException e2) {
                    if (e2.getCause() instanceof CertificateException) {
                        throw (CertificateException)e2.getCause();
                    }
                    throw new GeneralSecurityException("SSL connection error", e2);
                }
                catch (IOException e3) {
                    throw new GeneralSecurityException("IO error", e3);
                }
            }
            catch (Throwable throwable) {
                this.close((Closeable)response);
                this.close((Closeable)httpClient);
                throw throwable;
            }
        }
    }

    protected CloseableHttpClient createHttpClient(Service service) {
        SSLConnectionSocketFactory socketFactory;
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustEngineTrustStrategy(service)).build();
            socketFactory = new SSLConnectionSocketFactory(sslContext);
        }
        catch (Exception e) {
            throw new RuntimeException("SSL initialization error", e);
        }
        Registry registry = RegistryBuilder.create().register(HTTPS_SCHEME, (Object)socketFactory).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)registry);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    private void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                this.log.warn("Error closing " + resource, (Throwable)e);
            }
        }
    }

    private class TrustEngineTrustStrategy
    implements TrustStrategy {
        private final Logger log = LoggerFactory.getLogger(TrustEngineTrustStrategy.class);
        private final Service service;

        public TrustEngineTrustStrategy(Service s) {
            this.service = s;
        }

        public boolean isTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            if (certificates == null || certificates.length < 1) {
                return false;
            }
            try {
                this.log.debug("Validating cert {} issued by {}", (Object)certificates[0].getSubjectDN().getName(), (Object)certificates[0].getIssuerDN().getName());
                String entityID = this.service.getEntityDescriptor() != null ? this.service.getEntityDescriptor().getEntityID() : this.service.getName();
                CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("https://www.apereo.org/cas/protocol"), new UsageCriterion(UsageType.SIGNING)});
                return HttpClientProxyValidator.this.trustEngine.validate((Object)new BasicX509Credential(certificates[0]), criteria);
            }
            catch (SecurityException e) {
                throw new CertificateException("X509 validation error", e);
            }
        }
    }
}

