/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.cas.config.impl.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.impl.LoginConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class BuildAuthenticationContextAction
extends AbstractCASProtocolAction<ServiceTicketRequest, ServiceTicketResponse> {
    private final ConfigLookupFunction<LoginConfiguration> configLookupFunction = new ConfigLookupFunction<LoginConfiguration>(LoginConfiguration.class);

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        AuthenticationContext initialAuthnContext;
        LoginConfiguration config;
        AuthenticationContext ac = new AuthenticationContext();
        ac.setForceAuthn(((ServiceTicketRequest)this.getCASRequest(profileRequestContext)).isRenew());
        ac.setIsPassive(false);
        if (!ac.isForceAuthn() && (config = this.configLookupFunction.apply(profileRequestContext)) != null) {
            ac.setForceAuthn(config.getForceAuthnPredicate().apply((Object)profileRequestContext));
        }
        if ((initialAuthnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class)) != null) {
            ac.setInitialAuthenticationResult(initialAuthnContext.getAuthenticationResult());
        }
        profileRequestContext.addSubcontext((BaseContext)ac, true);
        profileRequestContext.setBrowserProfile(true);
        return null;
    }
}

