/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.cas.config.impl.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.impl.LoginConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GrantServiceTicketAction
extends AbstractCASProtocolAction<ServiceTicketRequest, ServiceTicketResponse> {
    private final Logger log = LoggerFactory.getLogger(GrantServiceTicketAction.class);
    private final ConfigLookupFunction<LoginConfiguration> configLookupFunction = new ConfigLookupFunction<LoginConfiguration>(LoginConfiguration.class);
    @Nonnull
    private final Function<ProfileRequestContext, SessionContext> sessionContextFunction = new ChildContextLookup(SessionContext.class, false);
    @Nonnull
    private final Function<ProfileRequestContext, AuthenticationContext> authnCtxLookupFunction = new ChildContextLookup(AuthenticationContext.class);
    @Nonnull
    private final Function<ProfileRequestContext, String> principalLookupFunction = Functions.compose((Function)new SubjectContextPrincipalLookupFunction(), (Function)new ChildContextLookup(SubjectContext.class));
    @Nonnull
    private final TicketServiceEx ticketServiceEx;

    public GrantServiceTicketAction(@Nonnull TicketServiceEx ticketService) {
        this.ticketServiceEx = (TicketServiceEx)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ServiceTicket ticket;
        ServiceTicketRequest request = (ServiceTicketRequest)this.getCASRequest(profileRequestContext);
        IdPSession session = this.getIdPSession(profileRequestContext);
        LoginConfiguration config = this.configLookupFunction.apply(profileRequestContext);
        if (config == null) {
            throw new IllegalStateException("Service ticket configuration undefined");
        }
        if (config.getSecurityConfiguration() == null || config.getSecurityConfiguration().getIdGenerator() == null) {
            throw new IllegalStateException("Invalid service ticket configuration: SecurityConfiguration#idGenerator undefined");
        }
        AuthenticationContext authnCtx = (AuthenticationContext)this.authnCtxLookupFunction.apply((Object)profileRequestContext);
        AuthenticationResult authnResult = authnCtx != null ? authnCtx.getAuthenticationResult() : this.getLatestAuthenticationResult(session);
        try {
            this.log.debug("Granting service ticket for {}", (Object)request.getService());
            TicketState state = new TicketState(session.getId(), this.getPrincipalName(profileRequestContext), new Instant(authnResult.getAuthenticationInstant()), authnResult.getAuthenticationFlowId());
            ticket = this.ticketServiceEx.createServiceTicket(config.getSecurityConfiguration().getIdGenerator().generateIdentifier(), DateTime.now().plus(config.getTicketValidityPeriod()).toInstant(), request.getService(), state, request.isRenew());
        }
        catch (RuntimeException e) {
            this.log.error("Failed granting service ticket due to error.", (Throwable)e);
            return ProtocolError.TicketCreationError.event((Object)this);
        }
        this.log.info("Granted service ticket for {}", (Object)request.getService());
        ServiceTicketResponse response = new ServiceTicketResponse(request.getService(), ticket.getId());
        if (request.isSAML()) {
            response.setSaml(true);
        }
        this.setCASResponse(profileRequestContext, response);
        return null;
    }

    @Nonnull
    private IdPSession getIdPSession(ProfileRequestContext prc) {
        SessionContext sessionContext = (SessionContext)this.sessionContextFunction.apply((Object)prc);
        if (sessionContext == null || sessionContext.getIdPSession() == null) {
            throw new IllegalStateException("Cannot locate IdP session");
        }
        return sessionContext.getIdPSession();
    }

    @Nonnull
    private String getPrincipalName(ProfileRequestContext prc) {
        String principal = (String)this.principalLookupFunction.apply((Object)prc);
        if (principal == null) {
            throw new IllegalStateException("Cannot determine IdP subject principal name.");
        }
        return principal;
    }

    private AuthenticationResult getLatestAuthenticationResult(IdPSession session) {
        AuthenticationResult latest = null;
        for (AuthenticationResult result : session.getAuthenticationResults()) {
            if (latest != null && result.getAuthenticationInstant() <= latest.getAuthenticationInstant()) continue;
            latest = result;
        }
        if (latest == null) {
            throw new IllegalStateException("Cannot find authentication results in IdP session");
        }
        return latest;
    }
}

