/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.StartsWithLocationCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataServiceRegistry
implements ServiceRegistry {
    public static final String LOGIN_BINDING = "https://www.apereo.org/cas/protocol/login";
    public static final String LOGOUT_BINDING = "https://www.apereo.org/cas/protocol/logout";
    public static final String LOGOUT_LOCATION = "urn:mace:shibboleth:profile:CAS:logout";
    public static final String PROXY_BINDING = "https://www.apereo.org/cas/protocol/proxy";
    private final Logger log = LoggerFactory.getLogger(MetadataServiceRegistry.class);
    @Nonnull
    private final MetadataResolver metadataResolver;

    public MetadataServiceRegistry(@Nonnull @ParameterName(name="resolver") MetadataResolver resolver) {
        this.metadataResolver = resolver;
    }

    @Nullable
    public Service lookup(@Nonnull String serviceURL) {
        try {
            ArrayList entities = Lists.newArrayList((Iterable)this.metadataResolver.resolve((Object)this.criteria(serviceURL)));
            if (entities.size() > 1) {
                throw new ResolverException("Multiple results found");
            }
            if (entities.size() == 1) {
                return this.create(serviceURL, (EntityDescriptor)entities.get(0));
            }
        }
        catch (ResolverException e) {
            this.log.warn("Metadata resolution failed for {}", (Object)serviceURL, (Object)e);
        }
        return null;
    }

    @Nonnull
    protected CriteriaSet criteria(@Nonnull String serviceURL) {
        AssertionConsumerService loginACS = new AssertionConsumerServiceBuilder().buildObject();
        loginACS.setBinding(LOGIN_BINDING);
        loginACS.setLocation(serviceURL);
        return new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new EndpointCriterion((Endpoint)loginACS), new ProtocolCriterion("https://www.apereo.org/cas/protocol"), new StartsWithLocationCriterion()});
    }

    @Nonnull
    protected Service create(@Nonnull String serviceURL, @Nonnull EntityDescriptor entity) {
        XMLObject parent = entity.getParent();
        Service service = new Service(serviceURL, parent instanceof EntitiesDescriptor ? ((EntitiesDescriptor)parent).getName() : "unknown", this.isAuthorizedToProxy(entity), this.hasSingleLogoutService(entity));
        service.setEntityDescriptor(entity);
        return service;
    }

    private boolean isAuthorizedToProxy(@Nonnull EntityDescriptor entity) {
        SPSSODescriptor descriptor = entity.getSPSSODescriptor("https://www.apereo.org/cas/protocol");
        if (descriptor != null) {
            for (AssertionConsumerService acs : descriptor.getAssertionConsumerServices()) {
                if (!PROXY_BINDING.equals(acs.getBinding())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSingleLogoutService(@Nonnull EntityDescriptor entity) {
        SPSSODescriptor descriptor = entity.getSPSSODescriptor("https://www.apereo.org/cas/protocol");
        if (descriptor != null) {
            for (Endpoint endpoint : descriptor.getEndpoints(SingleLogoutService.DEFAULT_ELEMENT_NAME)) {
                if (!LOGOUT_BINDING.equals(endpoint.getBinding()) || !LOGOUT_LOCATION.equals(endpoint.getLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public static class LoginEndpointPredicate
    implements Predicate<Endpoint> {
        public boolean apply(@Nullable Endpoint endpoint) {
            return MetadataServiceRegistry.LOGIN_BINDING.equals(endpoint.getBinding());
        }
    }
}

