/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingServiceRegistry
extends AbstractIdentifiableInitializableComponent
implements ServiceRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadingServiceRegistry.class);
    private final ReloadableService<ServiceRegistry> service;

    public ReloadingServiceRegistry(@Nonnull @ParameterName(name="delegate") ReloadableService<ServiceRegistry> delegate) {
        this.service = (ReloadableService)Constraint.isNotNull(delegate, (String)"ReloadableService cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Service lookup(@Nonnull String serviceURL) {
        ServiceableComponent component = null;
        try {
            component = this.service.getServiceableComponent();
            if (null == component) {
                this.log.error("ServiceRegistry '{}': error looking up service registry: Invalid configuration.", (Object)this.getId());
                Service service = null;
                return service;
            }
            Service service = ((ServiceRegistry)component.getComponent()).lookup(serviceURL);
            return service;
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }
}

