/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.impl.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractProtocolConfiguration
extends AbstractConditionalProfileConfiguration
implements InitializableComponent {
    public static final String PROTOCOL_URI = "https://www.apereo.org/cas/protocol";
    private boolean initialized;
    @Nullable
    private Function<ProfileRequestContext, Long> ticketValidityPeriodLookupStrategy;
    @Duration
    @Positive
    private long ticketValidityPeriod;
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = Predicates.alwaysTrue();

    public AbstractProtocolConfiguration(@Nonnull @NotEmpty String profileId) {
        this(profileId, 15000L);
    }

    public AbstractProtocolConfiguration(@Nonnull @NotEmpty String profileId, @Positive long ticketTTL) {
        super(profileId);
        this.ticketValidityPeriod = ticketTTL;
        this.setSecurityConfiguration(new SecurityConfiguration(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES), (IdentifierGenerationStrategy)new TicketIdentifierGenerationStrategy(this.getDefaultTicketPrefix(), this.getDefaultTicketLength())));
    }

    public void initialize() throws ComponentInitializationException {
        Constraint.isNotNull((Object)this.getSecurityConfiguration(), (String)"Security configuration cannot be null.");
        Constraint.isNotNull((Object)this.getSecurityConfiguration().getIdGenerator(), (String)"Security configuration ID generator cannot be null.");
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Duration
    @Positive
    public long getTicketValidityPeriod() {
        return Constraint.isGreaterThan((long)0L, (long)((Long)this.getIndirectProperty(this.ticketValidityPeriodLookupStrategy, this.ticketValidityPeriod)), (String)"Ticket validity period must be positive.");
    }

    @Duration
    public void setTicketValidityPeriod(@Duration @Positive long millis) {
        this.ticketValidityPeriod = Constraint.isGreaterThan((long)0L, (long)millis, (String)"Ticket validity period must be positive.");
    }

    public void setTicketValidityPeriodLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        this.ticketValidityPeriodLookupStrategy = strategy;
    }

    @Deprecated
    public boolean isResolveAttributes() {
        return this.resolveAttributesPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getResolveAttributesPredicate() {
        return this.resolveAttributesPredicate;
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    @Nonnull
    @NotEmpty
    protected abstract String getDefaultTicketPrefix();

    protected abstract int getDefaultTicketLength();
}

