/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.impl.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.impl.ProxyConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.joda.time.DateTime;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GrantProxyTicketAction
extends AbstractCASProtocolAction<ProxyTicketRequest, ProxyTicketResponse> {
    private final Logger log = LoggerFactory.getLogger(GrantProxyTicketAction.class);
    private final ConfigLookupFunction<ProxyConfiguration> configLookupFunction = new ConfigLookupFunction<ProxyConfiguration>(ProxyConfiguration.class);
    @Nonnull
    private final TicketServiceEx casTicketService;
    @Nonnull
    private final SessionResolver sessionResolver;
    private Predicate<ProfileRequestContext> validateIdPSessionPredicate = Predicates.alwaysFalse();

    public GrantProxyTicketAction(@Nonnull TicketServiceEx ticketService, @Nonnull SessionResolver resolver) {
        this.casTicketService = (TicketServiceEx)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setValidateIdPSessionPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.validateIdPSessionPredicate = predicate;
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ProxyTicket pt;
        ProxyGrantingTicket pgt = (ProxyGrantingTicket)this.getCASTicket(profileRequestContext);
        if (pgt == null || pgt.getExpirationInstant().isBeforeNow()) {
            return ProtocolError.TicketExpired.event((Object)this);
        }
        ProxyConfiguration config = this.configLookupFunction.apply(profileRequestContext);
        if (config == null) {
            this.log.warn("Proxy ticket configuration undefined");
            return ProtocolError.IllegalState.event((Object)this);
        }
        if (config.getSecurityConfiguration() == null || config.getSecurityConfiguration().getIdGenerator() == null) {
            this.log.warn("Invalid proxy ticket configuration: SecurityConfiguration#idGenerator undefined");
            return ProtocolError.IllegalState.event((Object)this);
        }
        if (this.validateIdPSessionPredicate.apply((Object)profileRequestContext)) {
            IdPSession session = null;
            try {
                this.log.debug("Attempting to retrieve session {}", (Object)pgt.getSessionId());
                session = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(pgt.getSessionId())}));
            }
            catch (ResolverException e) {
                this.log.warn("IdPSession resolution error: {}", (Throwable)e);
            }
            boolean expired = true;
            if (session == null) {
                this.log.info("IdPSession {} not found", (Object)pgt.getSessionId());
            } else {
                try {
                    expired = !session.checkTimeout();
                    this.log.debug("Session {} expired={}", (Object)pgt.getSessionId(), (Object)expired);
                }
                catch (SessionException e) {
                    this.log.warn("Error performing session timeout check: {}. Assuming session has expired.", (Throwable)e);
                }
            }
            if (expired) {
                return ProtocolError.SessionExpired.event((Object)this);
            }
        }
        ProxyTicketRequest request = (ProxyTicketRequest)this.getCASRequest(profileRequestContext);
        try {
            this.log.debug("Granting proxy ticket for {}", (Object)request.getTargetService());
            pt = this.casTicketService.createProxyTicket(config.getSecurityConfiguration().getIdGenerator().generateIdentifier(), DateTime.now().plus(config.getTicketValidityPeriod()).toInstant(), pgt, request.getTargetService());
        }
        catch (RuntimeException e) {
            this.log.error("Failed granting proxy ticket due to error.", (Throwable)e);
            return ProtocolError.TicketCreationError.event((Object)this);
        }
        this.log.info("Granted proxy ticket for {}", (Object)request.getTargetService());
        this.setCASResponse(profileRequestContext, new ProxyTicketResponse(pt.getId()));
        return null;
    }
}

