/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PopulateProtocolErrorAction
extends AbstractCASProtocolAction {
    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ProxyTicketResponse response;
        Object request = this.getCASRequest(profileRequestContext);
        if (request instanceof ProxyTicketRequest) {
            response = new ProxyTicketResponse();
        } else if (request instanceof TicketValidationRequest) {
            response = new TicketValidationResponse();
        } else {
            throw new IllegalArgumentException("Invalid request type: " + request);
        }
        String code = (String)springRequestContext.getCurrentEvent().getAttributes().get("code");
        String detail = (String)springRequestContext.getCurrentEvent().getAttributes().get("detailCode");
        if (code == null) {
            code = ProtocolError.IllegalState.getCode();
        }
        if (detail == null) {
            detail = ProtocolError.IllegalState.getDetailCode();
        }
        response.setErrorCode(code);
        response.setErrorDetail(detail);
        this.setCASResponse(profileRequestContext, response);
        return null;
    }
}

