/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.attribute.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.cas.attribute.AbstractCASAttributeTranscoder;
import net.shibboleth.idp.cas.attribute.Attribute;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CASStringAttributeTranscoder
extends AbstractCASAttributeTranscoder<StringAttributeValue> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CASStringAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof StringAttributeValue;
    }

    @Nullable
    protected String encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull StringAttributeValue value) throws AttributeEncodingException {
        if (value instanceof ScopedStringAttributeValue) {
            this.log.warn("Attribute '{}': Lossy encoding of attribute value of type {} to SAML1 String Attribute", (Object)attribute.getId(), (Object)value.getClass().getSimpleName());
        }
        return value.getValue();
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable String value) {
        return value != null ? StringAttributeValue.valueOf((String)value) : null;
    }
}

