/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.protocol.AbstractProtocolResponse;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class StatusCodeLookupFunction
implements Function<ProfileRequestContext, String> {
    @Nonnull
    @NotEmpty
    public static final String SUCCESS_CODE = "SUCCESS";
    @Nonnull
    private final Function<ProfileRequestContext, ProtocolContext> protocolContextFunction;

    public StatusCodeLookupFunction() {
        this((Function<ProfileRequestContext, ProtocolContext>)new ChildContextLookup(ProtocolContext.class));
    }

    public StatusCodeLookupFunction(@Nonnull Function<ProfileRequestContext, ProtocolContext> protocolLookup) {
        this.protocolContextFunction = (Function)Constraint.isNotNull(protocolLookup, (String)"ProtocolContext lookup cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        ProtocolContext protocolContext = this.protocolContextFunction.apply(input);
        if (protocolContext == null || protocolContext.getRequest() == null) {
            return null;
        }
        Object response = protocolContext.getResponse();
        if (response instanceof AbstractProtocolResponse) {
            String code = ((AbstractProtocolResponse)response).getErrorCode();
            return code == null ? SUCCESS_CODE : code;
        }
        return null;
    }
}

