/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildRelyingPartyContextAction<RequestType, ResponseType>
extends AbstractCASProtocolAction<RequestType, ResponseType> {
    @Nonnull
    @NotEmpty
    public static final String UNVERIFIED_GROUP = "unverified";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildRelyingPartyContextAction.class);
    @Nonnull
    @NonnullElements
    @NotEmpty
    private final List<ServiceRegistry> serviceRegistries;
    @Nullable
    private Object request;

    public BuildRelyingPartyContextAction(ServiceRegistry ... registries) {
        this.serviceRegistries = Arrays.asList((ServiceRegistry[])Constraint.isNotEmpty((Object[])registries, (String)"Service registries cannot be null"));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.request = this.getCASRequest(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    @Nonnull
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String serviceURL;
        if (this.request instanceof ServiceTicketRequest) {
            serviceURL = ((ServiceTicketRequest)this.request).getService();
        } else if (this.request instanceof ProxyTicketRequest) {
            serviceURL = ((ProxyTicketRequest)this.request).getTargetService();
        } else if (this.request instanceof TicketValidationRequest) {
            serviceURL = ((TicketValidationRequest)this.request).getService();
        } else {
            this.log.warn("{} Service URL not found in flow state", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Service service = this.query(serviceURL);
        RelyingPartyContext rpc = new RelyingPartyContext();
        rpc.setVerified(Boolean.valueOf(service != null));
        rpc.setRelyingPartyId(serviceURL);
        if (service != null) {
            this.log.debug("{} Setting up RP context for verified relying party {}", (Object)this.getLogPrefix(), (Object)service);
        } else {
            service = new Service(serviceURL, UNVERIFIED_GROUP, false);
            this.log.debug("{} Setting up RP context for unverified relying party {}", (Object)this.getLogPrefix(), (Object)service);
        }
        this.log.debug("{} Relying party context created for {}", (Object)this.getLogPrefix(), (Object)service);
        profileRequestContext.addSubcontext((BaseContext)rpc);
        try {
            this.setCASService(profileRequestContext, service);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
        }
    }

    @Nullable
    private Service query(String serviceURL) {
        for (ServiceRegistry registry : this.serviceRegistries) {
            this.log.debug("Querying {} for CAS service URL {}", (Object)registry.getClass().getName(), (Object)serviceURL);
            Service service = registry.lookup(serviceURL);
            if (service == null) continue;
            return service;
        }
        return null;
    }
}

