/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.attribute.transcoding.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.cas.attribute.AbstractCASAttributeTranscoder;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.idp.cas.attribute.transcoding.impl.CASDateTimeAttributeTranscoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CASDateTimeAttributeTranscoderTest {
    private AttributeTranscoderRegistryImpl registry;
    private static final String ATTR_ID = "foo";
    private static final String ATTR_NAME = "bar";
    private static final String STRING_SECS = "1659979872";
    private static final String STRING_MSECS = "1659979872969";
    private static final String STRING_ISO = "2022-08-08T17:31:12.969Z";
    private static final String STRING_INVALID = "invalid";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        CASDateTimeAttributeTranscoder transcoder = new CASDateTimeAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractCASAttributeTranscoder.NamingFunction())));
        HashMap<String, String> ruleset1 = new HashMap<String, String>();
        ruleset1.put("id", ATTR_ID);
        ruleset1.put("transcoder", (String)transcoder);
        ruleset1.put("cas.name", ATTR_NAME);
        this.registry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<1> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<DateTimeAttributeValue> values = List.of(new ByteAttributeValue(new byte[]{1, 2, 3}), new DateTimeAttributeValue(Instant.parse(STRING_ISO)));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Collection children = attr.getValues();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        String child = (String)children.iterator().next();
        Assert.assertEquals((String)child, (String)STRING_ISO);
    }

    @Test
    public void singleDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        casAttribute.getValues().add(STRING_SECS);
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        Assert.assertEquals((Object)((DateTimeAttributeValue)attr.getValues().get(0)).getValue(), (Object)Instant.ofEpochSecond(Long.valueOf(STRING_SECS)));
    }
}

