/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.attribute.transcoding.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.cas.attribute.AbstractCASAttributeTranscoder;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.idp.cas.attribute.transcoding.impl.CASStringAttributeTranscoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CASStringAttributeTranscoderTest {
    private AttributeTranscoderRegistryImpl registry;
    private static final String ATTR_ID = "foo";
    private static final String ATTR_NAME = "bar";
    private static final String STRING_1 = "Value The First";
    private static final String STRING_2 = "Second string the value is";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        CASStringAttributeTranscoder transcoder = new CASStringAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractCASAttributeTranscoder.NamingFunction())));
        HashMap<String, String> ruleset1 = new HashMap<String, String>();
        ruleset1.put("id", ATTR_ID);
        ruleset1.put("transcoder", (String)transcoder);
        ruleset1.put("cas.name", ATTR_NAME);
        this.registry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new StringAttributeValue(STRING_1));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Collection children = attr.getValues();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        String child = (String)children.iterator().next();
        Assert.assertEquals((String)child, (String)STRING_1);
    }

    @Test
    public void singleDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        casAttribute.getValues().add(STRING_1);
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        Assert.assertEquals((String)((StringAttributeValue)attr.getValues().get(0)).getValue().toString(), (String)STRING_1);
    }

    @Test
    public void multi() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new StringAttributeValue(STRING_1), new StringAttributeValue(STRING_2), new ScopedStringAttributeValue(STRING_1, STRING_2));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Collection children = attr.getValues();
        Assert.assertEquals((int)children.size(), (int)3, (String)"Encoding three entries");
        for (String child : children) {
            Assert.assertTrue((STRING_1.equals(child) || STRING_2.equals(child) ? 1 : 0) != 0);
        }
    }

    @Test
    public void multiDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        casAttribute.getValues().add(STRING_1);
        casAttribute.getValues().add(STRING_2);
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertEquals((int)attr.getValues().size(), (int)2);
        Assert.assertEquals((String)((StringAttributeValue)attr.getValues().get(0)).getValue().toString(), (String)STRING_1);
        Assert.assertEquals((String)((StringAttributeValue)attr.getValues().get(1)).getValue().toString(), (String)STRING_2);
    }
}

