/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.security.KeyException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.spring.IdPPropertiesApplicationContextInitializer;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import org.mockito.Mockito;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeSuite;

@ContextConfiguration(locations={"/spring/test-flow-beans.xml"}, initializers={IdPPropertiesApplicationContextInitializer.class})
@WebAppConfiguration
@TestPropertySource(properties={"idp.initializer.failFast = false"})
public abstract class AbstractFlowActionTest
extends AbstractTestNGSpringContextTests {
    protected static final String TEST_SESSION_ID = "+TkSGIRofZyue/p8F4M7TA==";
    protected static final String TEST_PRINCIPAL_NAME = "omega";
    @Autowired
    protected TicketService ticketService;
    private TicketIdentifierGenerationStrategy serviceTicketGenerator = new TicketIdentifierGenerationStrategy("ST", 25);
    private TicketIdentifierGenerationStrategy proxyTicketGenerator = new TicketIdentifierGenerationStrategy("PT", 25);
    private TicketIdentifierGenerationStrategy proxyGrantingTicketGenerator = new TicketIdentifierGenerationStrategy("PGT", 50);

    protected static ProfileRequestContext getProfileContext(RequestContext context) {
        return (ProfileRequestContext)context.getConversationScope().get("opensamlProfileRequestContext");
    }

    protected static IdPSession mockSession(String sessionId, boolean expiredFlag, AuthenticationResult ... results) {
        IdPSession mockSession = (IdPSession)Mockito.mock(IdPSession.class);
        Mockito.when((Object)mockSession.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)mockSession.getPrincipalName()).thenReturn((Object)TEST_PRINCIPAL_NAME);
        try {
            Mockito.when((Object)mockSession.checkTimeout()).thenReturn((Object)expiredFlag);
        }
        catch (SessionException e) {
            throw new RuntimeException("Session exception", e);
        }
        Mockito.when((Object)mockSession.getAuthenticationResults()).thenReturn(new HashSet<AuthenticationResult>(Arrays.asList(results)));
        return mockSession;
    }

    protected static Instant expiry() {
        return Instant.now().plusSeconds(30L);
    }

    protected String generateServiceTicketId() {
        return this.serviceTicketGenerator.generateIdentifier();
    }

    protected String generateProxyTicketId() {
        return this.proxyTicketGenerator.generateIdentifier();
    }

    protected String generateProxyGrantingTicketId() {
        return this.proxyGrantingTicketGenerator.generateIdentifier();
    }

    protected ServiceTicket createServiceTicket(String service, boolean renew) {
        TicketState state = new TicketState(TEST_SESSION_ID, TEST_PRINCIPAL_NAME, Instant.now(), "Password");
        return this.ticketService.createServiceTicket(this.generateServiceTicketId(), AbstractFlowActionTest.expiry(), service, state, renew);
    }

    protected ProxyTicket createProxyTicket(ProxyGrantingTicket pgt, String service) {
        return this.ticketService.createProxyTicket(this.generateProxyTicketId(), AbstractFlowActionTest.expiry(), pgt, service);
    }

    protected ProxyGrantingTicket createProxyGrantingTicket(ServiceTicket st) {
        return this.ticketService.createProxyGrantingTicket(this.generateProxyGrantingTicketId(), AbstractFlowActionTest.expiry(), st);
    }

    protected ProxyGrantingTicket createProxyGrantingTicket(ProxyTicket pt) {
        return this.ticketService.createProxyGrantingTicket(this.generateProxyGrantingTicketId(), AbstractFlowActionTest.expiry(), pt);
    }

    @BeforeSuite
    public void initOpenSAML() throws InitializationException {
        InitializationService.initialize();
    }

    public static class MockDataSealerKeyStrategy
    implements DataSealerKeyStrategy {
        private final SecretKey key;

        public MockDataSealerKeyStrategy() {
            byte[] bytes = new byte[32];
            new SecureRandom().nextBytes(bytes);
            this.key = new SecretKeySpec(bytes, "AES");
        }

        public Pair<String, SecretKey> getDefaultKey() throws KeyException {
            return new Pair((Object)"default", (Object)this.key);
        }

        public SecretKey getKey(String s) throws KeyException {
            return this.key;
        }
    }
}

