/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.BuildProxyChainAction;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BuildProxyChainActionTest
extends AbstractFlowActionTest {
    @Autowired
    private BuildProxyChainAction action;

    @Test
    public void testBuildChainLength2() throws Exception {
        ServiceTicket st = this.createServiceTicket("proxyA", true);
        ProxyGrantingTicket pgtA = this.createProxyGrantingTicket(st);
        ProxyTicket ptA = this.createProxyTicket(pgtA, "proxiedByA");
        ProxyGrantingTicket pgtB = this.createProxyGrantingTicket(ptA);
        ProxyTicket ptB = this.createProxyTicket(pgtB, "proxiedByB");
        TicketValidationRequest request = new TicketValidationRequest("proxiedByB", ptB.getId());
        TicketValidationResponse response = new TicketValidationResponse();
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/proxy").addProtocolContext(request, response).addTicketContext((Ticket)ptB).build();
        Assert.assertNull((Object)this.action.execute(context));
        Assert.assertEquals((int)response.getProxies().size(), (int)2);
        Assert.assertEquals((String)((String)response.getProxies().get(0)), (String)"proxiedByA");
        Assert.assertEquals((String)((String)response.getProxies().get(1)), (String)"proxyA");
    }

    @Test
    public void testBrokenProxyChain() throws Exception {
        ServiceTicket st = this.createServiceTicket("proxyA", true);
        ProxyGrantingTicket pgtA = this.createProxyGrantingTicket(st);
        ProxyTicket ptA = this.createProxyTicket(pgtA, "proxiedByA");
        ProxyGrantingTicket pgtB = this.createProxyGrantingTicket(ptA);
        ProxyTicket ptB = this.createProxyTicket(pgtB, "proxiedByB");
        ProxyGrantingTicket pgtC = this.createProxyGrantingTicket(ptB);
        ProxyTicket ptC = this.createProxyTicket(pgtC, "proxiedByC");
        TicketValidationRequest request = new TicketValidationRequest("proxiedByC", ptC.getId());
        TicketValidationResponse response = new TicketValidationResponse();
        this.ticketService.removeProxyGrantingTicket(pgtB.getId());
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/proxy").addProtocolContext(request, response).addTicketContext((Ticket)ptC).build();
        Assert.assertEquals((String)this.action.execute(context).getId(), (String)ProtocolError.BrokenProxyChain.name());
    }
}

