/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.BuildRelyingPartyContextAction;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.service.Service;
import org.opensaml.profile.action.EventException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BuildRelyingPartyContextActionTest
extends AbstractFlowActionTest {
    @Autowired
    private BuildRelyingPartyContextAction<?, ?> action;

    @Test
    public void testExecuteFromServiceTicketRequest() throws EventException {
        String serviceURL = "https://serviceA.example.org:8443/landing";
        RequestContext requestContext = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(new ServiceTicketRequest("https://serviceA.example.org:8443/landing"), null).build();
        Assert.assertNull((Object)this.action.execute(requestContext));
        Service service = this.action.getCASService(BuildRelyingPartyContextActionTest.getProfileContext(requestContext));
        Assert.assertEquals((String)"https://serviceA.example.org:8443/landing", (String)service.getName());
        Assert.assertEquals((String)"allowedToProxy", (String)service.getGroup());
        Assert.assertTrue((boolean)service.isAuthorizedToProxy());
    }

    @Test
    public void testExecuteFromTicketValidationRequest() throws EventException {
        String serviceURL = "http://serviceB.example.org/";
        RequestContext requestContext = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(new TicketValidationRequest("http://serviceB.example.org/", "ST-123"), null).build();
        Assert.assertNull((Object)this.action.execute(requestContext));
        Service service = this.action.getCASService(BuildRelyingPartyContextActionTest.getProfileContext(requestContext));
        Assert.assertEquals((String)"http://serviceB.example.org/", (String)service.getName());
        Assert.assertEquals((String)"notAllowedToProxy", (String)service.getGroup());
        Assert.assertFalse((boolean)service.isAuthorizedToProxy());
    }

    @Test
    public void testExecuteFromProxyTicketRequest() throws EventException {
        String serviceURL = "http://mallory.untrusted.org/";
        RequestContext requestContext = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(new ProxyTicketRequest("PGT-123", "http://mallory.untrusted.org/"), null).build();
        Assert.assertNull((Object)this.action.execute(requestContext));
        Service service = this.action.getCASService(BuildRelyingPartyContextActionTest.getProfileContext(requestContext));
        Assert.assertEquals((String)"http://mallory.untrusted.org/", (String)service.getName());
        Assert.assertEquals((String)"unverified", (String)service.getGroup());
        Assert.assertFalse((boolean)service.isAuthorizedToProxy());
    }
}

