/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.net.URI;
import java.security.cert.CertificateException;
import java.time.Instant;
import net.shibboleth.idp.cas.config.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.flow.impl.ValidateProxyCallbackAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.proxy.ProxyValidator;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ValidateProxyCallbackActionTest
extends AbstractFlowActionTest {
    @Test
    public void testValidateProxySuccess() throws Exception {
        ValidateProxyCallbackAction action = new ValidateProxyCallbackAction(ValidateProxyCallbackActionTest.mockProxyAuthenticator(null), this.ticketService);
        action.initialize();
        RequestContext context = ValidateProxyCallbackActionTest.newRequestContext("https://test.example.org/");
        Assert.assertNull((Object)action.execute(context));
        TicketValidationResponse response = (TicketValidationResponse)action.getCASResponse(ValidateProxyCallbackActionTest.getProfileContext(context));
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPgtIou());
    }

    @Test
    public void testValidateProxyFailure() throws Exception {
        ValidateProxyCallbackAction action = new ValidateProxyCallbackAction(ValidateProxyCallbackActionTest.mockProxyAuthenticator(new CertificateException()), this.ticketService);
        action.initialize();
        Assert.assertEquals((String)action.execute(ValidateProxyCallbackActionTest.newRequestContext("https://test.example.org/")).getId(), (String)ProtocolError.ProxyCallbackAuthenticationFailure.name());
    }

    private static ProxyValidator mockProxyAuthenticator(Exception toBeThrown) throws Exception {
        ProxyValidator validator = (ProxyValidator)Mockito.mock(ProxyValidator.class);
        if (toBeThrown != null) {
            ((ProxyValidator)Mockito.doThrow((Throwable[])new Throwable[]{toBeThrown}).when((Object)validator)).validate((ProfileRequestContext)Mockito.any(ProfileRequestContext.class), (URI)Mockito.any(URI.class));
        }
        return validator;
    }

    private static RequestContext newRequestContext(String pgtURL) {
        String service = "https://test.example.com/";
        String ticketId = "ST-123-ABCCEF";
        ServiceTicket st = new ServiceTicket("ST-123-ABCCEF", "https://test.example.com/", Instant.now(), false);
        st.setTicketState(new TicketState("SessionID-123", "bob", Instant.now(), "bob"));
        TicketValidationRequest request = new TicketValidationRequest("https://test.example.com/", "ST-123-ABCCEF");
        request.setPgtUrl(pgtURL);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/serviceValidate").addProtocolContext(request, new TicketValidationResponse()).addTicketContext((Ticket)st).addRelyingPartyContext("https://test.example.com/", true, (ProfileConfiguration)new ValidateConfiguration()).build();
        return context;
    }
}

