/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.EncodingTicketService;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.RandomIdentifierGenerationStrategy;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.binary.Base32;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EncodingTicketServiceTest {
    private EncodingTicketService ticketService;
    private IdentifierGenerationStrategy sessionIdGenerator = new RandomIdentifierGenerationStrategy(32);
    private IdentifierGenerationStrategy pgtIdGenerator = new TicketIdentifierGenerationStrategy("PGT", 32);
    private SecureRandom secureRandom;

    public EncodingTicketServiceTest() {
        try {
            this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Secure random creation failed", e);
        }
    }

    @BeforeClass
    public void setUp() throws Exception {
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeystoreResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.jks")));
        strategy.setKeyVersionResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.kver")));
        strategy.setKeystorePassword("password");
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("password");
        strategy.initialize();
        Base32 codec = new Base32(0, null, false, 45);
        DataSealer sealer = new DataSealer();
        sealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        sealer.setRandom(this.secureRandom);
        sealer.setEncoder((BinaryEncoder)codec);
        sealer.setDecoder((BinaryDecoder)codec);
        sealer.initialize();
        this.ticketService = new EncodingTicketService((StorageService)new MemoryStorageService(), sealer);
    }

    @Test
    public void testCreateRemoveServiceTicketSuccess() throws Exception {
        TicketState state = this.newState("aloysius");
        String service = "https://www.example.com/s1/";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        ServiceTicket st1 = this.ticketService.createServiceTicket(id, expiry, "https://www.example.com/s1/", state, true);
        Assert.assertNotNull((Object)st1);
        Assert.assertTrue((boolean)st1.getId().startsWith("ST-"));
        ServiceTicket st2 = this.ticketService.removeServiceTicket(st1.getId());
        Assert.assertNotNull((Object)st2);
        Assert.assertEquals((String)st1.getId(), (String)st2.getId());
        Assert.assertEquals((Object)expiry.truncatedTo(ChronoUnit.MILLIS), (Object)st2.getExpirationInstant());
        Assert.assertEquals((String)"https://www.example.com/s1/", (String)st2.getService());
        Assert.assertTrue((boolean)st2.isRenew());
        Assert.assertEquals((String)state.getSessionId(), (String)st2.getSessionId());
        Assert.assertEquals((Object)state, (Object)st2.getTicketState());
        ServiceTicket st3 = this.ticketService.removeServiceTicket(st1.getId());
        Assert.assertNotNull((Object)st3);
        Assert.assertEquals((String)st1.getId(), (String)st3.getId());
    }

    @Test
    public void testCreateRemoveServiceTicketInvalid() throws Exception {
        ServiceTicket st1 = this.ticketService.createServiceTicket(String.valueOf(System.currentTimeMillis()), Instant.now().plusSeconds(5L), "https://www.example.com/s2/", this.newState("bartholomew"), true);
        Assert.assertNotNull((Object)st1);
        Assert.assertNull((Object)this.ticketService.removeServiceTicket("ST-abc123"));
    }

    @Test
    public void testCreateServiceTicketSuccessWithLongID() throws Exception {
        TicketState state = this.newState("charlemagne@vt.edu");
        String service = "https://www.google.com/maps/place/Mountain+Lake+Lodge/@37.3554696,-80.539459,17z/data=!3m1!4b1!4m5!3m4!1s0x884dc6a58faa2119:0x17f3cc6a2c82b614!8m2!3d37.3554696!4d-80.537265";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        ServiceTicket st1 = this.ticketService.createServiceTicket(id, expiry, "https://www.google.com/maps/place/Mountain+Lake+Lodge/@37.3554696,-80.539459,17z/data=!3m1!4b1!4m5!3m4!1s0x884dc6a58faa2119:0x17f3cc6a2c82b614!8m2!3d37.3554696!4d-80.537265", state, true);
        Assert.assertNotNull((Object)st1);
        Assert.assertTrue((boolean)st1.getId().matches("ST-[A-Za-z0-9]+-*"));
        Assert.assertTrue((st1.getId().length() < 600 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateRemoveProxyTicketSuccess() throws Exception {
        ProxyGrantingTicket pgt = this.newPGT(this.newState("donegal"), "https://www.example.com/s1/");
        String service = "https://www.example.com/s2/";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        ProxyTicket pt1 = this.ticketService.createProxyTicket(id, expiry, pgt, "https://www.example.com/s2/");
        Assert.assertNotNull((Object)pt1);
        Assert.assertTrue((boolean)pt1.getId().startsWith("PT-"));
        ProxyTicket pt2 = this.ticketService.removeProxyTicket(pt1.getId());
        Assert.assertNotNull((Object)pt2);
        Assert.assertEquals((String)pt1.getId(), (String)pt2.getId());
        Assert.assertEquals((Object)expiry.truncatedTo(ChronoUnit.MILLIS), (Object)pt2.getExpirationInstant());
        Assert.assertEquals((String)"https://www.example.com/s2/", (String)pt2.getService());
        Assert.assertEquals((String)pgt.getId(), (String)pt2.getPgtId());
        Assert.assertEquals((Object)pgt.getTicketState(), (Object)pt2.getTicketState());
        ProxyTicket pt3 = this.ticketService.removeProxyTicket(pt1.getId());
        Assert.assertNotNull((Object)pt3);
        Assert.assertEquals((String)pt1.getId(), (String)pt3.getId());
    }

    @Test
    public void testCreateRemoveProxyTicketInvalid() throws Exception {
        ProxyGrantingTicket pgt = this.newPGT(this.newState("esquire"), "https://www.example.com/s1/");
        String service = "https://www.example.com/s2/";
        Instant expiry = Instant.now().plusSeconds(5L);
        String id = String.valueOf(System.currentTimeMillis());
        ProxyTicket pt1 = this.ticketService.createProxyTicket(id, expiry, pgt, "https://www.example.com/s2/");
        Assert.assertNotNull((Object)pt1);
        Assert.assertNull((Object)this.ticketService.removeProxyTicket("PT-123"));
    }

    @Test
    public void testCreateFetchRemoveEncodedProxyGrantingTicket() {
        String principal = "aleph";
        String serviceUrl = "https://www.example.com/pgt1/";
        ServiceTicket st = this.ticketService.createServiceTicket(String.valueOf(System.currentTimeMillis()), Instant.now().plusSeconds(5L), "https://www.example.com/pgt1/", this.newState("aleph"), true);
        Instant expiry = Instant.now().plusSeconds(3600L);
        ProxyGrantingTicket pgt = this.ticketService.createProxyGrantingTicket("notused", expiry, st);
        Assert.assertTrue((boolean)pgt.getId().startsWith("PGT-E-"));
        ProxyGrantingTicket pgt2 = this.ticketService.fetchProxyGrantingTicket(pgt.getId());
        Assert.assertNotNull((Object)pgt2);
        Assert.assertEquals((String)pgt2.getService(), (String)"https://www.example.com/pgt1/");
        Assert.assertEquals((String)pgt2.getTicketState().getPrincipalName(), (String)"aleph");
        ProxyGrantingTicket pgt3 = this.ticketService.removeProxyGrantingTicket(pgt.getId());
        Assert.assertNotNull((Object)pgt3);
        Assert.assertEquals((String)pgt3.getService(), (String)"https://www.example.com/pgt1/");
        Assert.assertEquals((String)pgt3.getTicketState().getPrincipalName(), (String)"aleph");
        Assert.assertNotNull((Object)this.ticketService.fetchProxyGrantingTicket(pgt.getId()));
    }

    private TicketState newState(String principal) {
        return new TicketState(this.sessionIdGenerator.generateIdentifier(), principal, Instant.now().truncatedTo(ChronoUnit.MILLIS), "authn/Password");
    }

    private ProxyGrantingTicket newPGT(TicketState state, String service) {
        ProxyGrantingTicket pgt = new ProxyGrantingTicket(this.pgtIdGenerator.generateIdentifier(), service, Instant.now().plusSeconds(300L), "PGT-12345");
        pgt.setTicketState(state);
        return pgt;
    }
}

