/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;

public abstract class AbstractOutgoingSamlMessageAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    @NotEmpty
    protected static final String NAMESPACE = "http://www.ja-sig.org/products/cas/";
    @Nonnull
    private QName envelopeName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope", "SOAP-ENV");
    @Nonnull
    private QName bodyName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body", "SOAP-ENV");
    @NonnullAfterInit
    private BindingDescriptor outgoingBinding;

    public void setOutgoingBinding(@Nonnull BindingDescriptor descriptor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.outgoingBinding = (BindingDescriptor)Constraint.isNotNull((Object)descriptor, (String)"Outgoing BindingDescriptor cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outgoingBinding == null) {
            throw new ComponentInitializationException("Outgoing BindingDescriptor cannot be null");
        }
    }

    @Nonnull
    protected static <T extends SAMLObject> T newSAMLObject(Class<T> type, QName elementName) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(elementName);
        return (T)builder.buildObject();
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgContext = new MessageContext();
        try {
            msgContext.setMessage((Object)this.buildSamlResponse(profileRequestContext));
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.IllegalState.event((Object)this));
            return;
        }
        SAMLBindingContext bindingContext = new SAMLBindingContext();
        bindingContext.setBindingUri(this.outgoingBinding.getId());
        bindingContext.setBindingDescriptor(this.outgoingBinding);
        msgContext.addSubcontext((BaseContext)bindingContext);
        Envelope envelope = (Envelope)XMLObjectSupport.buildXMLObject((QName)this.envelopeName);
        envelope.setBody((Body)XMLObjectSupport.buildXMLObject((QName)this.bodyName));
        SOAP11Context soapCtx = new SOAP11Context();
        soapCtx.setEnvelope(envelope);
        msgContext.addSubcontext((BaseContext)soapCtx);
        profileRequestContext.setOutboundMessageContext(msgContext);
    }

    @Nonnull
    protected abstract Response buildSamlResponse(@Nonnull ProfileRequestContext var1) throws EventException;
}

