/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.impl.ServiceEntityDescriptor;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class BuildSAMLMetadataContextAction<RequestType, ResponseType>
extends AbstractCASProtocolAction<RequestType, ResponseType> {
    private boolean relyingPartyIdFromMetadata;
    @Nullable
    private Service service;
    @Nullable
    private RelyingPartyContext rpCtx;

    public void setRelyingPartyIdFromMetadata(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyIdFromMetadata = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.service = this.getCASService(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        this.rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        if (this.rpCtx == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        ServiceEntityDescriptor entity = this.service.getEntityDescriptor() != null ? this.service.getEntityDescriptor() : new ServiceEntityDescriptor(this.service);
        mdCtx.setEntityDescriptor((EntityDescriptor)entity);
        mdCtx.setRoleDescriptor(this.service.getRoleDescriptor());
        if (this.relyingPartyIdFromMetadata) {
            this.rpCtx.setRelyingPartyId(entity.getEntityID());
        }
        this.rpCtx.setRelyingPartyIdContextTree((BaseContext)mdCtx);
    }
}

