/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import com.google.common.base.Predicates;
import java.time.Instant;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.ProxyConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantProxyTicketAction
extends AbstractCASProtocolAction<ProxyTicketRequest, ProxyTicketResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GrantProxyTicketAction.class);
    @Nonnull
    private final ConfigLookupFunction<ProxyConfiguration> configLookupFunction;
    @Nonnull
    private final TicketService casTicketService;
    @Nonnull
    private final SessionResolver sessionResolver;
    @Nonnull
    private Predicate<ProfileRequestContext> validateIdPSessionPredicate;
    @Nullable
    private ProxyConfiguration proxyConfig;
    @Nullable
    private SecurityConfiguration securityConfig;
    @Nullable
    private ProxyGrantingTicket pgt;
    @Nullable
    private ProxyTicketRequest request;

    public GrantProxyTicketAction(@Nonnull TicketService ticketService, @Nonnull SessionResolver resolver) {
        this.casTicketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
        this.validateIdPSessionPredicate = Predicates.alwaysFalse();
        this.configLookupFunction = new ConfigLookupFunction(ProxyConfiguration.class);
    }

    public void setValidateIdPSessionPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validateIdPSessionPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Session validation condition cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.proxyConfig = (ProxyConfiguration)this.configLookupFunction.apply(profileRequestContext);
        if (this.proxyConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.securityConfig = this.proxyConfig.getSecurityConfiguration(profileRequestContext);
        if (this.securityConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        try {
            this.request = (ProxyTicketRequest)this.getCASRequest(profileRequestContext);
            this.pgt = (ProxyGrantingTicket)this.getCASTicket(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProxyTicket pt;
        if (this.pgt.getExpirationInstant().isBefore(Instant.now())) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.TicketExpired.event((Object)this));
            return;
        }
        if (this.validateIdPSessionPredicate.test(profileRequestContext)) {
            IdPSession session = null;
            try {
                this.log.debug("{} Attempting to retrieve session {}", (Object)this.getLogPrefix(), (Object)this.pgt.getSessionId());
                session = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(this.pgt.getSessionId())}));
            }
            catch (ResolverException e) {
                this.log.warn("{} IdPSession resolution error: {}", (Object)this.getLogPrefix(), (Object)e);
            }
            boolean expired = true;
            if (session == null) {
                this.log.info("{} IdPSession {} not found", (Object)this.getLogPrefix(), (Object)this.pgt.getSessionId());
            } else {
                try {
                    expired = !session.checkTimeout();
                    this.log.debug("{} Session {} expired={}", new Object[]{this.getLogPrefix(), this.pgt.getSessionId(), expired});
                }
                catch (SessionException e) {
                    this.log.warn("{} Error performing session timeout check: {}. Assuming session has expired.", (Object)this.getLogPrefix(), (Object)e);
                }
            }
            if (expired) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.SessionExpired.event((Object)this));
                return;
            }
        }
        try {
            this.log.debug("{} Granting proxy ticket for {}", (Object)this.getLogPrefix(), (Object)this.request.getTargetService());
            pt = this.casTicketService.createProxyTicket(this.securityConfig.getIdGenerator().generateIdentifier(), Instant.now().plus(this.proxyConfig.getTicketValidityPeriod(profileRequestContext)), this.pgt, this.request.getTargetService());
        }
        catch (RuntimeException e) {
            this.log.error("Failed granting proxy ticket due to error.", (Throwable)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.TicketCreationError.event((Object)this));
            return;
        }
        try {
            this.setCASResponse(profileRequestContext, new ProxyTicketResponse(pt.getId()));
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return;
        }
        this.log.info("{} Granted proxy ticket for {}", (Object)this.getLogPrefix(), (Object)this.request.getTargetService());
    }
}

