/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.SamlParam;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.profile.ActionSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.opensaml.saml.saml1.core.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ProcessSamlMessageAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessSamlMessageAction.class);

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        profileRequestContext.setProfileId("https://www.apereo.org/cas/protocol/serviceValidate");
        ParameterMap params = springRequestContext.getRequestParameters();
        String service = params.get(SamlParam.TARGET.name());
        if (service == null) {
            return ProtocolError.ServiceNotSpecified.event((Object)this);
        }
        MessageContext msgContext = profileRequestContext.getInboundMessageContext();
        String ticket = null;
        if (msgContext.getMessage() instanceof Request) {
            Request request = (Request)msgContext.getMessage();
            Iterator iterator = request.getAssertionArtifacts().iterator();
            if (iterator.hasNext()) {
                AssertionArtifact artifact = (AssertionArtifact)iterator.next();
                ticket = artifact.getValue();
            }
        } else {
            this.log.warn("{} Unexpected SAMLObject type {}", (Object)this.getLogPrefix(), (Object)msgContext.getMessage().getClass().getName());
            return ProtocolError.ProtocolViolation.event((Object)this);
        }
        if (ticket == null) {
            return ProtocolError.TicketNotSpecified.event((Object)this);
        }
        TicketValidationRequest ticketValidationRequest = new TicketValidationRequest(service, ticket);
        String renew = params.get(ProtocolParam.Renew.id());
        if (renew != null) {
            ticketValidationRequest.setRenew(true);
        }
        try {
            this.setCASRequest(profileRequestContext, ticketValidationRequest);
        }
        catch (EventException e) {
            return ActionSupport.buildEvent((Object)((Object)this), (String)e.getEventID());
        }
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }
}

