/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRenewAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateRenewAction.class);
    @Nullable
    private Ticket ticket;
    @Nullable
    private TicketValidationRequest request;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.ticket = this.getCASTicket(profileRequestContext);
            this.request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.ticket instanceof ServiceTicket) {
            if (this.request.isRenew() != ((ServiceTicket)this.ticket).isRenew()) {
                this.log.debug("{} Renew=true requested at validation time but ticket not issued with renew=true", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.TicketNotFromRenew.event((Object)this));
                return;
            }
        } else if (this.request.isRenew()) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.RenewIncompatibleWithProxy.event((Object)this));
            return;
        }
    }
}

