/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.session.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSessionEx;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class CASSPSession
extends BasicSPSession
implements SPSessionEx {
    @Nonnull
    @NotEmpty
    private final String ticket;

    public CASSPSession(@Nonnull @NotEmpty String id, @Nonnull Instant creation, @Nonnull Instant expiration, @Nonnull @NotEmpty String ticketId) {
        super(id, creation, expiration);
        this.ticket = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ticketId), (String)"Ticket ID cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getTicketId() {
        return this.ticket;
    }

    public String getSPSessionKey() {
        return this.ticket;
    }

    @Nullable
    @NotEmpty
    public String getProtocol() {
        return "https://www.apereo.org/cas/protocol";
    }

    public boolean supportsLogoutPropagation() {
        return true;
    }

    public String toString() {
        return "CASSPSession: " + this.getId() + " via " + this.ticket;
    }
}

