/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.attribute.transcoding.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.cas.attribute.AbstractCASAttributeTranscoder;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.idp.cas.attribute.transcoding.impl.CASScopedStringAttributeTranscoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CASScopedStringAttributeTranscoderTest {
    private AttributeTranscoderRegistryImpl registry;
    private static final String ATTR_ID = "foo";
    private static final String ATTR_NAME = "bar";
    private static final String STRING_1 = "Value The First";
    private static final String STRING_2 = "Second string the value is";
    private static final String SCOPE_1 = "scope1.example.org";
    private static final String SCOPE_2 = "scope2";
    private static final String DELIMITER = "#";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        CASScopedStringAttributeTranscoder transcoder = new CASScopedStringAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractCASAttributeTranscoder.NamingFunction())));
        HashMap<String, String> ruleset1 = new HashMap<String, String>();
        ruleset1.put("id", ATTR_ID);
        ruleset1.put("transcoder", (String)transcoder);
        ruleset1.put("cas.name", ATTR_NAME);
        ruleset1.put("cas.scopeDelimiter", DELIMITER);
        this.registry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1), new StringAttributeValue(STRING_1), new StringAttributeValue("Value The First@scope1.example.org"));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Collection children = attr.getValues();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        String child = (String)children.iterator().next();
        Assert.assertEquals((String)child, (String)"Value The First#scope1.example.org", (String)"Input equals output");
    }

    @Test
    public void singleDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        casAttribute.getValues().add("Value The First#scope1.example.org");
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        ScopedStringAttributeValue value = (ScopedStringAttributeValue)attr.getValues().get(0);
        Assert.assertEquals((String)value.getValue(), (String)STRING_1);
        Assert.assertEquals((String)value.getScope(), (String)SCOPE_1);
    }

    @Test
    public void multi() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1), new ScopedStringAttributeValue(STRING_2, SCOPE_2));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_ID);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Collection children = attr.getValues();
        Assert.assertEquals((int)children.size(), (int)2, (String)"Encoding 2 entries");
        Iterator iter = children.iterator();
        String child1 = (String)iter.next();
        String child2 = (String)iter.next();
        String value1 = "Value The First#scope1.example.org";
        String value2 = "Second string the value is#scope2";
        Assert.assertTrue((child1.equals("Value The First#scope1.example.org") || child1.equals("Second string the value is#scope2") ? 1 : 0) != 0);
        Assert.assertTrue((child2.equals("Value The First#scope1.example.org") || child2.equals("Second string the value is#scope2") ? 1 : 0) != 0);
    }

    @Test
    public void multiDecode() throws Exception {
        Attribute casAttribute = new Attribute(ATTR_NAME);
        casAttribute.getValues().add("Value The First#scope1.example.org");
        casAttribute.getValues().add("Second string the value is#scope2");
        casAttribute.getValues().add("Second string the value is@scope2");
        casAttribute.getValues().add(STRING_2);
        Collection rulesets = this.registry.getTranscodingRules((Object)casAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)casAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_ID);
        Assert.assertEquals((int)attr.getValues().size(), (int)2);
        ScopedStringAttributeValue value1 = (ScopedStringAttributeValue)attr.getValues().get(0);
        ScopedStringAttributeValue value2 = (ScopedStringAttributeValue)attr.getValues().get(1);
        Assert.assertTrue((STRING_1.equals(value1.getValue()) || STRING_1.equals(value2.getValue()) ? 1 : 0) != 0);
        Assert.assertTrue((STRING_2.equals(value1.getValue()) || STRING_2.equals(value2.getValue()) ? 1 : 0) != 0);
        Assert.assertTrue((SCOPE_1.equals(value1.getScope()) || SCOPE_1.equals(value2.getScope()) ? 1 : 0) != 0);
        Assert.assertTrue((SCOPE_2.equals(value1.getScope()) || SCOPE_2.equals(value2.getScope()) ? 1 : 0) != 0);
    }
}

