/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.List;
import java.util.function.Function;
import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.BuildSAMLMetadataContextAction;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.metadata.EntityGroupName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BuildSAMLMetadataContextActionTest
extends AbstractFlowActionTest {
    @Autowired
    private BuildSAMLMetadataContextAction<?, ?> action;
    private Function<ProfileRequestContext, SAMLMetadataContext> mdLookupFunction = new SAMLMetadataContextLookupFunction();

    @Test
    public void testServiceWithGroup() throws Exception {
        Service service = new Service("https://service-1.example.org/", "group-1", true);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addRelyingPartyContext(service.getName(), true, null).addServiceContext(service).build();
        Assert.assertNull((Object)this.action.execute(context));
        SAMLMetadataContext mdc = this.mdLookupFunction.apply(BuildSAMLMetadataContextActionTest.getProfileContext(context));
        Assert.assertNotNull((Object)mdc);
        List groups = mdc.getEntityDescriptor().getObjectMetadata().get(EntityGroupName.class);
        Assert.assertEquals((int)groups.size(), (int)1);
        Assert.assertEquals((String)((EntityGroupName)groups.get(0)).getName(), (String)service.getGroup());
    }

    @Test
    public void testServiceWithoutGroup() throws Exception {
        Service service = new Service("https://service-2.example.org/", null, true);
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addRelyingPartyContext(service.getName(), true, null).addServiceContext(service).build();
        Assert.assertNull((Object)this.action.execute(context));
        SAMLMetadataContext mdc = this.mdLookupFunction.apply(BuildSAMLMetadataContextActionTest.getProfileContext(context));
        Assert.assertNotNull((Object)mdc);
        List groups = mdc.getEntityDescriptor().getObjectMetadata().get(EntityGroupName.class);
        Assert.assertTrue((boolean)groups.isEmpty());
    }
}

