/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.security.Principal;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.cas.config.LoginConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.GrantServiceTicketAction;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GrantServiceTicketActionTest
extends AbstractFlowActionTest {
    @Autowired
    private GrantServiceTicketAction action;

    @DataProvider(name="messages")
    public Object[][] provideMessages() {
        ServiceTicketRequest renewedRequest = new ServiceTicketRequest("https://www.example.com/beta");
        renewedRequest.setRenew(true);
        return new Object[][]{{new ServiceTicketRequest("https://www.example.com/alpha")}, {renewedRequest}};
    }

    @Test(dataProvider="messages")
    public void testExecute(ServiceTicketRequest request) throws Exception {
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/login").addProtocolContext(request, null).addAuthenticationContext(new AuthenticationResult("Password", (Principal)new UsernamePrincipal("bob"))).addSessionContext(GrantServiceTicketActionTest.mockSession("1234567890", true, new AuthenticationResult[0])).addSubjectContext("omega").addRelyingPartyContext(request.getService(), true, (ProfileConfiguration)new LoginConfiguration()).build();
        Assert.assertNull((Object)this.action.execute(context));
        ServiceTicketResponse response = (ServiceTicketResponse)this.action.getCASResponse(GrantServiceTicketActionTest.getProfileContext(context));
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getTicket());
        Assert.assertEquals((String)response.getService(), (String)request.getService());
        ServiceTicket ticket = this.ticketService.removeServiceTicket(response.getTicket());
        Assert.assertNotNull((Object)ticket);
        Assert.assertEquals((boolean)ticket.isRenew(), (boolean)request.isRenew());
        Assert.assertEquals((String)ticket.getId(), (String)response.getTicket());
        Assert.assertEquals((String)ticket.getService(), (String)response.getService());
        Assert.assertEquals((String)ticket.getTicketState().getPrincipalName(), (String)"omega");
    }
}

