/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.proxy.impl;

import java.io.IOException;
import java.net.URI;
import java.security.cert.CertificateException;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.proxy.impl.HttpClientProxyValidator;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class HttpClientProxyValidatorTest
extends AbstractFlowActionTest {
    @Autowired
    private HttpClientProxyValidator validator;
    @Autowired
    private ApplicationContext context;

    @DataProvider(name="data")
    public Object[][] buildTestData() {
        return new Object[][]{{"https://localhost:8443", "src/test/resources/credentials/localhost.p12", 200, null}, {"https://nobody-1.middleware.vt.edu/", "src/test/resources/credentials/nobody-1.p12", 200, null}, {"https://localhost:8443", "src/test/resources/credentials/localhost.p12", 404, new FailedLoginException()}, {"https://localhost:8443", "src/test/resources/credentials/nobody-2.p12", 200, new CertificateException()}, {"https://localhost:8443", "src/test/resources/credentials/idp-1371.p12", 200, new CertificateException()}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="data")
    public void testAuthenticate(String serviceURL, String keyStorePath, int status, Exception expected) throws Exception {
        Server server = null;
        try {
            server = this.startServer(keyStorePath, (Handler)new ConfigurableStatusHandler(status));
            this.validator.validate(this.buildProfileRequestContext(serviceURL), new URI("https://localhost:8443/?pgtId=A&pgtIOU=B"));
            if (expected != null) {
                Assert.fail((String)("Proxy authentication should have failed with " + expected));
            }
        }
        catch (Exception e) {
            if (expected == null) {
                throw e;
            }
            Assert.assertTrue((boolean)expected.getClass().isAssignableFrom(e.getClass()));
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private Server startServer(String keyStorePath, Handler handler) {
        final Server server = new Server();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStoreType("PKCS12");
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword("changeit");
        ServerConnector connector = new ServerConnector(server, sslContextFactory);
        connector.setHost("127.0.0.1");
        connector.setPort(8443);
        server.setConnectors(new Connector[]{connector});
        server.setHandler(handler);
        try {
            server.start();
        }
        catch (Exception e) {
            try {
                server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Jetty startup failed", e);
        }
        Thread serverRunner = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    server.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        serverRunner.start();
        return server;
    }

    private ProfileRequestContext buildProfileRequestContext(String serviceUrl) {
        ProfileRequestContext prc = new ProfileRequestContext();
        ProtocolContext protoCtx = new ProtocolContext();
        prc.addSubcontext((BaseContext)protoCtx);
        protoCtx.addSubcontext((BaseContext)new ServiceContext(new Service(serviceUrl, "unknown", true, false)));
        return prc;
    }

    private static class ConfigurableStatusHandler
    extends AbstractHandler {
        final int status;

        public ConfigurableStatusHandler(int s) {
            this.status = s;
        }

        public void handle(String target, Request request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
            servletResponse.setContentType("text/plain;charset=utf-8");
            servletResponse.setStatus(this.status);
            request.setHandled(true);
            servletResponse.getWriter().println("OK");
        }
    }
}

