/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.SimpleTicketService;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SimpleTicketServiceTest {
    private static final String TEST_SESSION_ID = "jHXRo42W0ATPEN+X5Zk1cw==";
    private static final String TEST_SERVICE = "https://example.com/widget";
    private SimpleTicketService ticketService;

    @BeforeClass
    public void setUp() throws Exception {
        MemoryStorageService ss = new MemoryStorageService();
        ss.setId("shibboleth.StorageService");
        ss.initialize();
        this.ticketService = new SimpleTicketService((StorageService)ss);
    }

    @Test
    public void testCreateRemoveServiceTicket() throws Exception {
        ServiceTicket st = this.createServiceTicket();
        Assert.assertNotNull((Object)st);
        Assert.assertNotNull((Object)st.getTicketState().getSessionId());
        Assert.assertNotNull((Object)st.getTicketState().getPrincipalName());
        ServiceTicket st2 = this.ticketService.removeServiceTicket(st.getId());
        Assert.assertEquals((Object)st, (Object)st2);
        Assert.assertEquals((Object)st.getExpirationInstant(), (Object)st2.getExpirationInstant());
        Assert.assertEquals((String)st.getService(), (String)st2.getService());
        Assert.assertEquals((Object)st.getTicketState(), (Object)st2.getTicketState());
        Assert.assertNull((Object)this.ticketService.removeServiceTicket(st.getId()));
    }

    @Test
    public void testCreateFetchRemoveProxyGrantingTicket() throws Exception {
        ProxyGrantingTicket pgt = this.createProxyGrantingTicket();
        Assert.assertNotNull((Object)pgt);
        Assert.assertNotNull((Object)pgt.getTicketState().getSessionId());
        Assert.assertNotNull((Object)pgt.getTicketState().getPrincipalName());
        ProxyGrantingTicket pgt2 = this.ticketService.fetchProxyGrantingTicket(pgt.getId());
        Assert.assertEquals((Object)pgt, (Object)pgt2);
        Assert.assertEquals((Object)pgt.getExpirationInstant(), (Object)pgt2.getExpirationInstant());
        Assert.assertEquals((String)pgt.getService(), (String)pgt2.getService());
        Assert.assertEquals((Object)pgt.getTicketState(), (Object)pgt2.getTicketState());
        Assert.assertEquals((Object)this.ticketService.removeProxyGrantingTicket(pgt.getId()), (Object)pgt);
        Assert.assertNull((Object)this.ticketService.removeProxyGrantingTicket(pgt.getId()));
    }

    @Test
    public void testCreateRemoveProxyTicket() throws Exception {
        ProxyTicket pt = this.ticketService.createProxyTicket(new TicketIdentifierGenerationStrategy("PT", 25).generateIdentifier(), SimpleTicketServiceTest.expiry(), this.createProxyGrantingTicket(), TEST_SERVICE);
        Assert.assertNotNull((Object)pt);
        Assert.assertNotNull((Object)pt.getTicketState().getSessionId());
        Assert.assertNotNull((Object)pt.getTicketState().getPrincipalName());
        ProxyTicket pt2 = this.ticketService.removeProxyTicket(pt.getId());
        Assert.assertEquals((Object)pt, (Object)pt2);
        Assert.assertEquals((Object)pt.getExpirationInstant(), (Object)pt2.getExpirationInstant());
        Assert.assertEquals((String)pt.getService(), (String)pt2.getService());
        Assert.assertEquals((Object)pt.getTicketState(), (Object)pt2.getTicketState());
        Assert.assertNull((Object)this.ticketService.removeProxyTicket(pt.getId()));
    }

    private ServiceTicket createServiceTicket() {
        return this.ticketService.createServiceTicket(new TicketIdentifierGenerationStrategy("ST", 25).generateIdentifier(), SimpleTicketServiceTest.expiry(), TEST_SERVICE, new TicketState(TEST_SESSION_ID, "bob", Instant.now().truncatedTo(ChronoUnit.MILLIS), "Password"), false);
    }

    private ProxyGrantingTicket createProxyGrantingTicket() {
        return this.ticketService.createProxyGrantingTicket(new TicketIdentifierGenerationStrategy("PGT", 50).generateIdentifier(), SimpleTicketServiceTest.expiry(), this.createServiceTicket());
    }

    private static Instant expiry() {
        return Instant.now().plusSeconds(10L).truncatedTo(ChronoUnit.MILLIS);
    }
}

