/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.serialization.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyGrantingTicketSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProxyGrantingTicketSerializerTest {
    private ProxyGrantingTicketSerializer serializer = new ProxyGrantingTicketSerializer();

    @Test
    public void testSerializeWithoutTicketState() throws Exception {
        ProxyGrantingTicket pgt1 = new ProxyGrantingTicket("ST-0123456789-9d22c36953a31fd12f12d30d76b344d3", "https://nobody.example.org", Instant.now().truncatedTo(ChronoUnit.MILLIS), null);
        String serialized = this.serializer.serialize((Ticket)pgt1);
        ProxyGrantingTicket pgt2 = (ProxyGrantingTicket)this.serializer.deserialize(1L, "notused", pgt1.getId(), serialized, null);
        Assert.assertEquals((String)pgt2.getId(), (String)pgt1.getId());
        Assert.assertEquals((String)pgt2.getService(), (String)pgt1.getService());
        Assert.assertEquals((Object)pgt2.getExpirationInstant(), (Object)pgt1.getExpirationInstant());
        Assert.assertEquals((String)pgt2.getParentId(), (String)pgt1.getParentId());
        Assert.assertEquals((Object)pgt2.getTicketState(), (Object)pgt1.getTicketState());
    }

    @Test
    public void testSerializeWithTicketState() throws Exception {
        ProxyGrantingTicket pgt1 = new ProxyGrantingTicket("ST-0123456789-fbca86ba09d1be7ec3ac17e6f372be87", "https://nobody.example.org", Instant.now().truncatedTo(ChronoUnit.MILLIS), null);
        pgt1.setTicketState(new TicketState("idpsess-1e663b80e6c6b2b7ae778cb3ea265", "bob", Instant.now().truncatedTo(ChronoUnit.MILLIS), "Password"));
        String serialized = this.serializer.serialize((Ticket)pgt1);
        ProxyGrantingTicket pgt2 = (ProxyGrantingTicket)this.serializer.deserialize(1L, "notused", pgt1.getId(), serialized, null);
        Assert.assertEquals((String)pgt2.getId(), (String)pgt1.getId());
        Assert.assertEquals((String)pgt2.getService(), (String)pgt1.getService());
        Assert.assertEquals((Object)pgt2.getExpirationInstant(), (Object)pgt1.getExpirationInstant());
        Assert.assertEquals((String)pgt2.getParentId(), (String)pgt1.getParentId());
        Assert.assertEquals((Object)pgt2.getTicketState(), (Object)pgt1.getTicketState());
    }

    @Test
    public void testSerializeWithParentAndTicketState() throws Exception {
        ProxyGrantingTicket pgt1 = new ProxyGrantingTicket("ST-0123456789-fbca86ba09d1be7ec3ac17e6f372be87", "https://nobody.example.org", Instant.now().truncatedTo(ChronoUnit.MILLIS), "PGT-0987654321-0040c390cf67e571c7e12fcc78fc0cb3");
        pgt1.setTicketState(new TicketState("idpsess-6d986af1280b7f52f9e7da434cfd0", "bob", Instant.now().truncatedTo(ChronoUnit.MILLIS), "Password"));
        String serialized = this.serializer.serialize((Ticket)pgt1);
        ProxyGrantingTicket pgt2 = (ProxyGrantingTicket)this.serializer.deserialize(1L, "notused", pgt1.getId(), serialized, null);
        Assert.assertEquals((String)pgt2.getId(), (String)pgt1.getId());
        Assert.assertEquals((String)pgt2.getService(), (String)pgt1.getService());
        Assert.assertEquals((Object)pgt2.getExpirationInstant(), (Object)pgt1.getExpirationInstant());
        Assert.assertEquals((String)pgt2.getParentId(), (String)pgt1.getParentId());
        Assert.assertEquals((Object)pgt2.getTicketState(), (Object)pgt1.getTicketState());
    }
}

