/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.serialization.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.serialization.impl.ServiceTicketSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ServiceTicketSerializerTest {
    private ServiceTicketSerializer serializer = new ServiceTicketSerializer();

    @Test
    public void testSerializeWithoutTicketState() throws Exception {
        ServiceTicket st1 = new ServiceTicket("ST-0123456789-616ea1550eef862761e5931bdccaaba0", "https://nobody.example.org", Instant.now().truncatedTo(ChronoUnit.MILLIS), true);
        String serialized = this.serializer.serialize((Ticket)st1);
        ServiceTicket st2 = (ServiceTicket)this.serializer.deserialize(1L, "notused", st1.getId(), serialized, null);
        Assert.assertEquals((String)st2.getId(), (String)st1.getId());
        Assert.assertEquals((String)st2.getService(), (String)st1.getService());
        Assert.assertEquals((Object)st2.getExpirationInstant(), (Object)st1.getExpirationInstant());
        Assert.assertEquals((boolean)st2.isRenew(), (boolean)st1.isRenew());
        Assert.assertEquals((Object)st2.getTicketState(), (Object)st1.getTicketState());
    }

    @Test
    public void testSerializeWithTicketState() throws Exception {
        ServiceTicket st1 = new ServiceTicket("ST-0123456789-e6342d467a4414e599aa3c323528e96f", "https://nobody.example.org", Instant.now().truncatedTo(ChronoUnit.MILLIS), true);
        st1.setTicketState(new TicketState("idpsess-d2db22058dc178d3b917363859e", "bob", Instant.now().truncatedTo(ChronoUnit.MILLIS), "Password"));
        String serialized = this.serializer.serialize((Ticket)st1);
        ServiceTicket st2 = (ServiceTicket)this.serializer.deserialize(1L, "notused", st1.getId(), serialized, null);
        Assert.assertEquals((String)st2.getId(), (String)st1.getId());
        Assert.assertEquals((String)st2.getService(), (String)st1.getService());
        Assert.assertEquals((Object)st2.getExpirationInstant(), (Object)st1.getExpirationInstant());
        Assert.assertEquals((boolean)st2.isRenew(), (boolean)st1.isRenew());
        Assert.assertEquals((Object)st2.getTicketState(), (Object)st1.getTicketState());
    }

    @Test
    public void testSerializeWithConsent() throws Exception {
        ServiceTicket st1 = new ServiceTicket("ST-0123456789-e6342d467a4414e599aa3c323528e96f", "https://nobody.example.org", Instant.now().truncatedTo(ChronoUnit.MILLIS), true);
        TicketState state = new TicketState("idpsess-d2db22058dc178d3b917363859e", "bob", Instant.now().truncatedTo(ChronoUnit.MILLIS), "Password");
        state.setConsentedAttributeIds(Set.of("foo", "bar"));
        st1.setTicketState(state);
        String serialized = this.serializer.serialize((Ticket)st1);
        ServiceTicket st2 = (ServiceTicket)this.serializer.deserialize(1L, "notused", st1.getId(), serialized, null);
        Assert.assertEquals((String)st2.getId(), (String)st1.getId());
        Assert.assertEquals((String)st2.getService(), (String)st1.getService());
        Assert.assertEquals((Object)st2.getExpirationInstant(), (Object)st1.getExpirationInstant());
        Assert.assertEquals((boolean)st2.isRenew(), (boolean)st1.isRenew());
        Assert.assertEquals((Object)st2.getTicketState(), (Object)st1.getTicketState());
    }

    @Test
    public void testSerializeWithEmptyConsent() throws Exception {
        ServiceTicket st1 = new ServiceTicket("ST-0123456789-e6342d467a4414e599aa3c323528e96f", "https://nobody.example.org", Instant.now().truncatedTo(ChronoUnit.MILLIS), true);
        TicketState state = new TicketState("idpsess-d2db22058dc178d3b917363859e", "bob", Instant.now().truncatedTo(ChronoUnit.MILLIS), "Password");
        state.setConsentedAttributeIds(Collections.emptySet());
        st1.setTicketState(state);
        String serialized = this.serializer.serialize((Ticket)st1);
        ServiceTicket st2 = (ServiceTicket)this.serializer.deserialize(1L, "notused", st1.getId(), serialized, null);
        Assert.assertEquals((String)st2.getId(), (String)st1.getId());
        Assert.assertEquals((String)st2.getService(), (String)st1.getService());
        Assert.assertEquals((Object)st2.getExpirationInstant(), (Object)st1.getExpirationInstant());
        Assert.assertEquals((boolean)st2.isRenew(), (boolean)st1.isRenew());
        Assert.assertEquals((Object)st2.getTicketState(), (Object)st1.getTicketState());
    }
}

