/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.serialization.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTicketSerializer<T extends Ticket>
implements StorageSerializer<T> {
    @Nonnull
    @NotEmpty
    private static final String SERVICE_FIELD = "rp";
    @Nonnull
    @NotEmpty
    private static final String EXPIRATION_FIELD = "exp";
    @Nonnull
    @NotEmpty
    private static final String STATE_FIELD = "ts";
    @Nonnull
    @NotEmpty
    private static final String SESSION_FIELD = "sid";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_FIELD = "p";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_INSTANT_FIELD = "ai";
    @Nonnull
    @NotEmpty
    private static final String AUTHN_METHOD_FIELD = "am";
    @Nonnull
    @NotEmpty
    private static final String CONSENTED_ATTRS_FIELD = "con";
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger(AbstractTicketSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(null);
    @Nonnull
    private final JsonReaderFactory readerFactory = Json.createReaderFactory(null);

    public void initialize() throws ComponentInitializationException {
    }

    public boolean isInitialized() {
        return true;
    }

    @Nonnull
    public String serialize(@Nonnull T ticket) throws IOException {
        StringWriter buffer = new StringWriter(200);
        try (JsonGenerator gen = this.generatorFactory.createGenerator((Writer)buffer);){
            gen.writeStartObject().write(SERVICE_FIELD, ticket.getService()).write(EXPIRATION_FIELD, ticket.getExpirationInstant().toEpochMilli());
            if (ticket.getTicketState() != null) {
                gen.writeStartObject(STATE_FIELD).write(SESSION_FIELD, ticket.getTicketState().getSessionId()).write(PRINCIPAL_FIELD, ticket.getTicketState().getPrincipalName()).write(AUTHN_INSTANT_FIELD, ticket.getTicketState().getAuthenticationInstant().toEpochMilli()).write(AUTHN_METHOD_FIELD, ticket.getTicketState().getAuthenticationMethod());
                if (ticket.getTicketState().getConsentedAttributeIds() != null) {
                    gen.writeStartArray(CONSENTED_ATTRS_FIELD);
                    for (String id : ticket.getTicketState().getConsentedAttributeIds()) {
                        gen.write(id);
                    }
                    gen.writeEnd();
                }
                gen.writeEnd();
            }
            this.serializeInternal(gen, ticket);
            gen.writeEnd();
        }
        catch (JsonException e) {
            this.logger.error("Exception serializing {}", ticket, (Object)e);
            throw new IOException("Exception serializing ticket", e);
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public T deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        try (JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));){
            TicketState state;
            JsonObject to = reader.readObject();
            String service = to.getString(SERVICE_FIELD);
            Instant expiry = Instant.ofEpochMilli(to.getJsonNumber(EXPIRATION_FIELD).longValueExact());
            JsonObject so = to.getJsonObject(STATE_FIELD);
            if (so != null) {
                state = new TicketState(so.getString(SESSION_FIELD), so.getString(PRINCIPAL_FIELD), Instant.ofEpochMilli(so.getJsonNumber(AUTHN_INSTANT_FIELD).longValueExact()), so.getString(AUTHN_METHOD_FIELD));
                JsonValue consent = (JsonValue)so.get((Object)CONSENTED_ATTRS_FIELD);
                if (consent instanceof JsonArray) {
                    HashSet<String> idset = new HashSet<String>();
                    for (JsonValue id : (JsonArray)consent) {
                        if (!(id instanceof JsonString)) continue;
                        idset.add(((JsonString)id).getString());
                    }
                    state.setConsentedAttributeIds(idset);
                }
            } else {
                state = null;
            }
            T ticket = this.createTicket(to, key, service, expiry);
            ticket.setTicketState(state);
            T t = ticket;
            return t;
        }
        catch (JsonException e) {
            this.logger.error("Exception deserializing {}", (Object)value, (Object)e);
            throw new IOException("Exception deserializing ticket", e);
        }
    }

    protected abstract T createTicket(@Nonnull JsonObject var1, @Nonnull String var2, @Nonnull String var3, @Nonnull Instant var4);

    protected abstract void serializeInternal(@Nonnull JsonGenerator var1, @Nonnull T var2);
}

