/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.impl.ServiceEntityDescriptor;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class BuildSAMLMetadataContextAction<RequestType, ResponseType>
extends AbstractCASProtocolAction<RequestType, ResponseType> {
    private boolean relyingPartyIdFromMetadata;
    @NonnullBeforeExec
    private Service service;
    @NonnullBeforeExec
    private RelyingPartyContext rpCtx;

    public void setRelyingPartyIdFromMetadata(boolean flag) {
        this.checkSetterPreconditions();
        this.relyingPartyIdFromMetadata = flag;
    }

    @Nonnull
    public Service getService() {
        assert (this.isPreExecuteCalled());
        return this.service;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.service = this.getCASService(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        this.rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        if (this.rpCtx == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLMetadataContext mdCtx = new SAMLMetadataContext();
        EntityDescriptor entity = this.getService().getEntityDescriptor();
        if (entity == null) {
            entity = new ServiceEntityDescriptor(this.getService());
        }
        mdCtx.setEntityDescriptor(entity);
        mdCtx.setRoleDescriptor(this.getService().getRoleDescriptor());
        if (this.relyingPartyIdFromMetadata) {
            this.rpCtx.setRelyingPartyId(entity.getEntityID());
        }
        this.rpCtx.setRelyingPartyIdContextTree((BaseContext)mdCtx);
    }
}

