/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.SamlParam;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.opensaml.saml.saml1.core.Request;
import org.slf4j.Logger;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ProcessSamlMessageAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessSamlMessageAction.class);

    @Nullable
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        profileRequestContext.setProfileId("https://www.apereo.org/cas/protocol/serviceValidate");
        ParameterMap params = springRequestContext.getRequestParameters();
        String service = params.get(SamlParam.TARGET.name());
        if (service == null) {
            return ProtocolError.ServiceNotSpecified.event((Object)this);
        }
        MessageContext msgContext = profileRequestContext.ensureInboundMessageContext();
        String ticket = null;
        Object message = msgContext.getMessage();
        if (message != null && message instanceof Request) {
            Request request = (Request)message;
            Iterator iterator = request.getAssertionArtifacts().iterator();
            if (iterator.hasNext()) {
                AssertionArtifact artifact = (AssertionArtifact)iterator.next();
                ticket = artifact.getValue();
            }
        } else {
            if (message == null) {
                this.log.warn("{} Unexpected null message", (Object)this.getLogPrefix());
                return ProtocolError.ProtocolViolation.event((Object)this);
            }
            this.log.warn("{} Unexpected SAMLObject type {}", (Object)this.getLogPrefix(), (Object)message.getClass().getName());
            return ProtocolError.ProtocolViolation.event((Object)this);
        }
        if (ticket == null) {
            return ProtocolError.TicketNotSpecified.event((Object)this);
        }
        TicketValidationRequest ticketValidationRequest = new TicketValidationRequest(service, ticket);
        String renew = params.get(ProtocolParam.Renew.id());
        if (renew != null) {
            ticketValidationRequest.setRenew(true);
        }
        try {
            this.setCASRequest(profileRequestContext, ticketValidationRequest);
        }
        catch (EventException e) {
            return ActionSupport.buildEvent((Object)((Object)this), (String)e.getEventID());
        }
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }
}

